/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.policyrule.saml.impl.AbstractEntityAttributePolicyRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;

public abstract class AbstractEntityAttributeRegexPolicyRule
extends AbstractEntityAttributePolicyRule {
    @NonnullAfterInit
    private Pattern valueRegex;

    @NonnullAfterInit
    public Pattern getValueRegex() {
        return this.valueRegex;
    }

    public void setValueRegex(@Nullable Pattern attributeValueRegex) {
        this.valueRegex = attributeValueRegex;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.valueRegex == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No regexp supplied to compare with");
        }
    }

    @Override
    protected boolean entityAttributeValueMatches(@Nonnull Set<String> entityAttributeValues) {
        return entityAttributeValues.stream().anyMatch(v -> this.valueRegex.matcher((CharSequence)v).matches());
    }
}

