/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.saml.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.saml.metadata.ScopesContainer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public abstract class AbstractMatchesShibMDScopeMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMatchesShibMDScopeMatcher.class);
    @Nullable
    private String logPrefix;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        List entityContainers;
        List roleContainers;
        SAMLMetadataContext issuerContext = filterContext.getIssuerMetadataContext();
        if (issuerContext == null) {
            LOG.warn("{} internal error: no IssueContext found", (Object)this.getLogPrefix());
            return CollectionSupport.emptySet();
        }
        RoleDescriptor roleDescriptor = issuerContext.getRoleDescriptor();
        EntityDescriptor entityDescriptor = issuerContext.getEntityDescriptor();
        if (roleDescriptor == null) {
            LOG.debug("{} No Role Descriptor found");
            roleContainers = CollectionSupport.emptyList();
        } else {
            roleContainers = roleDescriptor.getObjectMetadata().get(ScopesContainer.class);
        }
        if (entityDescriptor == null) {
            LOG.debug("{} No Entity Descriptor found");
            entityContainers = CollectionSupport.emptyList();
        } else {
            entityContainers = entityDescriptor.getObjectMetadata().get(ScopesContainer.class);
        }
        LinkedHashSet<IdPAttributeValue> matchedValues = new LinkedHashSet<IdPAttributeValue>(attribute.getValues().size());
        LOG.debug("{} Applying shibmd scope comparison to all values of Attribute '{}'", (Object)this.getLogPrefix(), (Object)attribute.getId());
        if (entityContainers.isEmpty() && roleContainers.isEmpty()) {
            LOG.debug("{} No <shibmd:Scope> found for {}, no atributes matched", (Object)this.getLogPrefix(), (Object)(entityDescriptor == null ? "<unknown>" : entityDescriptor.getID()));
            return CollectionSupport.emptySet();
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            assert (value != null);
            String compareString = this.getCompareString(value);
            if (compareString == null) {
                LOG.trace("{} not adding null-valued value {}", (Object)this.getLogPrefix(), (Object)value.getNativeValue().toString());
                continue;
            }
            if (!roleContainers.stream().anyMatch(e -> e.matchesScope(compareString)) && !entityContainers.stream().anyMatch(e -> e.matchesScope(compareString))) continue;
            LOG.trace("{} {} matches, adding value {}", new Object[]{this.getLogPrefix(), compareString, value.getNativeValue().toString()});
            matchedValues.add(value);
        }
        LOG.debug("{} returning {} values", (Object)this.getLogPrefix(), (Object)matchedValues.size());
        return CollectionSupport.copyToSet(matchedValues);
    }

    @Nullable
    @NotEmpty
    protected abstract String getCompareString(@Nonnull IdPAttributeValue var1);

    @Nonnull
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        assert (prefix != null);
        return prefix;
    }
}

