/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.logic.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.matcher.logic.impl.AbstractComposedMatcher;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class OrMatcher
extends AbstractComposedMatcher {
    @Nullable
    @Unmodifiable
    @NotLive
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        List<Matcher> currentMatchers = this.getComposedMatchers();
        this.checkComponentActive();
        LinkedHashSet matchingValues = new LinkedHashSet();
        for (Matcher matchFunctor : currentMatchers) {
            Set matches = matchFunctor.getMatchingValues(attribute, filterContext);
            if (null == matches) {
                return null;
            }
            matchingValues.addAll(matches);
        }
        return CollectionSupport.copyToSet(matchingValues);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getComposedMatchers().isEmpty()) {
            throw new ComponentInitializationException("No matchers supplied to OR");
        }
    }
}

