/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.matcher.impl.AbstractMatcher;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

public abstract class AbstractRegexpStringMatcher
extends AbstractMatcher {
    @NonnullAfterInit
    private Pattern pattern;

    @NonnullAfterInit
    public String getRegularExpression() {
        return this.pattern.pattern();
    }

    public void setPattern(@Nonnull Pattern thePattern) {
        this.checkSetterPreconditions();
        this.pattern = (Pattern)Constraint.isNotNull((Object)thePattern, (String)"Pattern supplied to setPattern but not be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.pattern) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No regular expression provided");
        }
    }

    protected boolean regexpCompare(@Nullable String value) {
        this.checkComponentActive();
        if (this.pattern == null || value == null) {
            return false;
        }
        return this.pattern.matcher(value).matches();
    }
}

