/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base32Support;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ComputedPairwiseIdStore
extends AbstractInitializableComponent
implements PairwiseIdStore {
    @Nonnull
    @NotEmpty
    public static final String WILDCARD_OVERRIDE = "*";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedPairwiseIdStore.class);
    @NonnullAfterInit
    private byte[] salt;
    @Nonnull
    @NotEmpty
    private String algorithm = "SHA";
    @Nonnull
    private Encoding encoding = Encoding.BASE64;
    @Nonnull
    private Map<String, Map<String, String>> exceptionMap = CollectionSupport.emptyMap();
    @Nullable
    private BiFunction<ProfileRequestContext, PairwiseId, String> saltLookupStrategy;
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    @NonnullAfterInit
    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(@Nullable byte[] newValue) {
        this.checkSetterPreconditions();
        if (newValue != null && newValue.length > 0) {
            this.salt = newValue;
        }
    }

    public void setSalt(@Nullable String newValue) {
        this.checkSetterPreconditions();
        if (newValue != null && !newValue.isEmpty()) {
            this.salt = newValue.getBytes();
        }
    }

    public void setEncodedSalt(@Nullable String newValue) {
        this.checkSetterPreconditions();
        if (newValue != null && !newValue.isEmpty()) {
            try {
                this.salt = Base64Support.decode((String)newValue);
            }
            catch (DecodingException e) {
                throw new IllegalArgumentException("Can not decode base64 encoded salt value", e);
            }
        }
    }

    @Nonnull
    @NotEmpty
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        this.checkSetterPreconditions();
        this.algorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alg), (String)"Digest algorithm cannot be null or empty");
    }

    @Nonnull
    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nonnull Encoding enc) {
        this.checkSetterPreconditions();
        this.encoding = (Encoding)((Object)Constraint.isNotNull((Object)((Object)enc), (String)"Encoding cannot be null"));
    }

    public void setExceptionMap(@Nullable @NotEmpty Map<String, Map<String, String>> map) {
        this.checkSetterPreconditions();
        if (map == null) {
            this.exceptionMap = CollectionSupport.emptyMap();
        } else {
            this.exceptionMap = new HashMap<String, Map<String, String>>(map.size());
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                String principal = StringSupport.trimOrNull((String)entry.getKey());
                if (principal == null || entry.getValue() == null) continue;
                HashMap<String, String> overrides = new HashMap<String, String>(entry.getValue().size());
                for (Map.Entry<String, String> subentry : entry.getValue().entrySet()) {
                    String rpname = StringSupport.trimOrNull((String)subentry.getKey());
                    if (rpname == null) continue;
                    String override = StringSupport.trimOrNull((String)subentry.getValue());
                    overrides.put(rpname, override);
                }
                this.exceptionMap.put(principal, overrides);
            }
        }
    }

    public void setSaltLookupStrategy(@Nullable BiFunction<ProfileRequestContext, PairwiseId, String> strategy) {
        this.checkSetterPreconditions();
        this.saltLookupStrategy = strategy;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> supplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = supplier;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getSalt() && this.saltLookupStrategy == null) {
            throw new ComponentInitializationException("Global salt and salt lookup strategy cannot both be null");
        }
        if (this.getSalt().length < 16) {
            throw new ComponentInitializationException("Salt must be at least 16 bytes in size");
        }
    }

    @Nullable
    public PairwiseId getBySourceValue(@Nonnull PairwiseId pid, boolean allowCreate) throws IOException {
        block7: {
            this.checkComponentActive();
            Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
            String recipientId = Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
            String sourceId = Constraint.isNotEmpty((String)pid.getSourceSystemId(), (String)"Source system ID cannot be null or empty");
            Constraint.isNotEmpty((String)pid.getPrincipalName(), (String)"Principal name cannot be null or empty");
            byte[] effectiveSalt = this.getEffectiveSalt(pid);
            if (effectiveSalt == null) {
                this.log.warn("Pairwise ID generation blocked for relying party ({}), no salt available", (Object)pid.getRecipientEntityID());
                throw new IOException("Pairwise ID generation blocked due to absence of salt");
            }
            try {
                MessageDigest md = MessageDigest.getInstance(this.algorithm);
                md.update(recipientId.getBytes());
                md.update((byte)33);
                md.update(sourceId.getBytes());
                md.update((byte)33);
                byte[] digestedEffectiveSalt = md.digest(effectiveSalt);
                assert (digestedEffectiveSalt != null);
                if (this.encoding == Encoding.BASE32) {
                    pid.setPairwiseId(Base32Support.encode((byte[])digestedEffectiveSalt, (boolean)false));
                    break block7;
                }
                if (this.encoding == Encoding.BASE64) {
                    pid.setPairwiseId(Base64Support.encode((byte[])digestedEffectiveSalt, (boolean)false));
                    break block7;
                }
                throw new IOException("Desired encoding was not recognized, unable to compute ID");
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("Digest algorithm {} is not supported", (Object)this.algorithm);
                throw new IOException("Digest algorithm was not supported, unable to compute ID", e);
            }
            catch (EncodingException e) {
                this.log.error("Unable to {} encode digest", (Object)this.encoding);
                throw new IOException("Unable to either base64 or base32 encode digest, unable to compute ID", e);
            }
        }
        return pid;
    }

    @Nullable
    private byte[] getEffectiveSalt(@Nonnull @NotEmpty PairwiseId pid) {
        Map<String, String> override = this.exceptionMap.get(pid.getPrincipalName());
        if (override == null) {
            override = this.exceptionMap.get(WILDCARD_OVERRIDE);
        }
        if (override != null) {
            if (override.containsKey(pid.getRecipientEntityID())) {
                String s = override.get(pid.getRecipientEntityID());
                if (s != null) {
                    this.log.debug("Overriding salt for principal '{}' and relying party '{}'", (Object)pid.getPrincipalName(), (Object)pid.getRecipientEntityID());
                    return s.getBytes();
                }
                this.log.debug("Blocked generation of ID for principal '{}' for relying party '{}'", (Object)pid.getPrincipalName(), (Object)pid.getRecipientEntityID());
                return null;
            }
            if (override.containsKey(WILDCARD_OVERRIDE)) {
                String s = override.get(WILDCARD_OVERRIDE);
                if (s != null) {
                    this.log.debug("Overriding salt for principal '{}' and relying party '{}'", (Object)pid.getPrincipalName(), (Object)pid.getRecipientEntityID());
                    return s.getBytes();
                }
                this.log.debug("Blocked generation of ID for principal '{}' for relying party '{}'", (Object)pid.getPrincipalName(), (Object)pid.getRecipientEntityID());
                return null;
            }
        }
        if (this.saltLookupStrategy != null) {
            ProfileRequestContext prc = this.httpServletRequestSupplier != null ? (ProfileRequestContext)((HttpServletRequest)this.httpServletRequestSupplier.get()).getAttribute("opensamlProfileRequestContext") : null;
            assert (this.saltLookupStrategy != null);
            String derivedSalt = this.saltLookupStrategy.apply(prc, pid);
            if (derivedSalt != null) {
                return derivedSalt.getBytes();
            }
        }
        return this.salt;
    }

    public static enum Encoding {
        BASE64,
        BASE32;

    }
}

