/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionHolder;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.accept.SemanticApiVersionParser;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;

public class ApiVersionMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return SemanticApiVersionParser.Version.class == parameter.nestedIfOptional().getNestedParameterType();
    }

    public @Nullable Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Assert.state((request != null ? 1 : 0) != 0, (String)"No HttpServletRequest");
        ApiVersionHolder versionHolder = (ApiVersionHolder)request.getAttribute(HandlerMapping.API_VERSION_ATTRIBUTE);
        Comparable version = versionHolder.getVersionIfPresent();
        if (parameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(version);
        }
        if (version == null) {
            if (!parameter.isOptional()) {
                throw new MissingApiVersionException();
            }
            return null;
        }
        if (version instanceof SemanticApiVersionParser.Version) {
            SemanticApiVersionParser.Version semanticApiVersion = (SemanticApiVersionParser.Version)version;
            return semanticApiVersion;
        }
        throw new IllegalStateException("Unexpected version type: " + String.valueOf(version.getClass()));
    }
}

