/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

@ThreadSafe
public class ProxyAuthenticationPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PROXY_AUTH_FIELD = "AA";
    @Nonnull
    @NotEmpty
    private static final String PROXY_COUNT_FIELD = "PXC";
    @Nonnull
    @NotEmpty
    private static final String PROXY_AUD_FIELD = "AUD";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"AA\":.*\\}$");
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory;

    public ProxyAuthenticationPrincipalSerializer() {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        assert (factory != null);
        this.objectBuilderFactory = factory;
    }

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof ProxyAuthenticationPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        ProxyAuthenticationPrincipal proxyPrincipal = (ProxyAuthenticationPrincipal)principal;
        JsonArrayBuilder arrayBuilder = this.getJsonArrayBuilder();
        proxyPrincipal.getAuthorities().forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(PROXY_AUTH_FIELD, (JsonValue)arrayBuilder.build());
            Integer proxyCount = proxyPrincipal.getProxyCount();
            if (proxyCount != null) {
                gen.write(PROXY_COUNT_FIELD, proxyCount.intValue());
            }
            if (!proxyPrincipal.getAudiences().isEmpty()) {
                JsonArrayBuilder arrayBuilder2 = this.getJsonArrayBuilder();
                proxyPrincipal.getAudiences().forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder2).add(arg_0));
                gen.write(PROXY_AUD_FIELD, (JsonValue)arrayBuilder2.build());
            }
            gen.writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ProxyAuthenticationPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonValue audiences;
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing ProxyAuthenticationPrincipal");
            }
            JsonValue jsonValue = (JsonValue)((JsonObject)st).get((Object)PROXY_AUTH_FIELD);
            if (jsonValue == null) throw new IOException("Serialized ProxyAuthenticationPrincipal missing primary array field");
            if (!JsonValue.ValueType.ARRAY.equals((Object)jsonValue.getValueType())) throw new IOException("Serialized ProxyAuthenticationPrincipal missing primary array field");
            ProxyAuthenticationPrincipal ret = new ProxyAuthenticationPrincipal();
            for (JsonValue e : (JsonArray)jsonValue) {
                if (!JsonValue.ValueType.STRING.equals((Object)e.getValueType())) continue;
                ret.getAuthorities().add(((JsonString)e).getString());
            }
            JsonValue count = (JsonValue)((JsonObject)st).get((Object)PROXY_COUNT_FIELD);
            if (count != null) {
                if (!JsonValue.ValueType.NUMBER.equals((Object)count.getValueType())) throw new IOException("Found invalid data structure while parsing ProxyAuthenticationPrincipal");
                ret.setProxyCount(Integer.valueOf(((JsonNumber)count).intValueExact()));
            }
            if ((audiences = (JsonValue)((JsonObject)st).get((Object)PROXY_AUD_FIELD)) != null) {
                if (!JsonValue.ValueType.ARRAY.equals((Object)audiences.getValueType())) throw new IOException("Found invalid data structure while parsing ProxyAuthenticationPrincipal");
                for (JsonValue e : (JsonArray)audiences) {
                    if (!JsonValue.ValueType.STRING.equals((Object)e.getValueType())) continue;
                    ret.getAudiences().add(((JsonString)e).getString());
                }
            }
            ProxyAuthenticationPrincipal proxyAuthenticationPrincipal = ret;
            return proxyAuthenticationPrincipal;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing ProxyAuthenticationPrincipal", e);
        }
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        JsonArrayBuilder result = this.objectBuilderFactory.createArrayBuilder();
        assert (result != null);
        return result;
    }
}

