/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UserAgentContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateUserAgentAddress
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.address";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUserAgentAddress.class);
    @Nonnull
    private Map<String, Collection<IPRange>> mappings;
    @NonnullBeforeExec
    private UserAgentContext uaContext;
    @Nullable
    private String principalName;

    public ValidateUserAgentAddress() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.mappings = CollectionSupport.emptyMap();
    }

    public void setMappings(@Nullable Map<String, Collection<IPRange>> newMappings) {
        this.checkSetterPreconditions();
        if (newMappings != null) {
            this.mappings = new HashMap<String, Collection<IPRange>>(newMappings.size());
            for (Map.Entry<String, Collection<IPRange>> e : newMappings.entrySet()) {
                if (Strings.isNullOrEmpty((String)e.getKey())) continue;
                this.mappings.put(e.getKey(), List.copyOf(e.getValue()));
            }
        } else {
            this.mappings = CollectionSupport.emptyMap();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.uaContext = (UserAgentContext)authenticationContext.getSubcontext(UserAgentContext.class);
        if (this.uaContext == null) {
            this.log.debug("{} No UserAgentContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.uaContext.getAddress() == null) {
            this.log.debug("{} No address available within UserAgentContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        InetAddress addr = this.uaContext.getAddress();
        assert (addr != null);
        for (Map.Entry<String, Collection<IPRange>> e : this.mappings.entrySet()) {
            Collection<IPRange> ranges = e.getValue();
            assert (ranges != null);
            if (!this.isAuthenticated(addr, ranges)) continue;
            this.principalName = e.getKey();
            this.log.info("{} Authenticated user agent with address {} as {}", new Object[]{this.getLogPrefix(), addr.getHostAddress(), this.principalName});
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            return;
        }
        this.log.debug("{} User agent with address {} was not authenticated", (Object)this.getLogPrefix(), (Object)addr.getHostAddress());
        this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
        this.recordFailure(profileRequestContext);
    }

    private boolean isAuthenticated(@Nonnull InetAddress address, @Nonnull Collection<IPRange> ranges) {
        byte[] resolvedAddress = address.getAddress();
        assert (resolvedAddress != null);
        for (IPRange range : ranges) {
            if (!range.contains(resolvedAddress)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        assert (this.principalName != null);
        UsernamePrincipal principal = new UsernamePrincipal(this.principalName);
        subject.getPrincipals().add((Principal)principal);
        return subject;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.principalName != null) {
            return CollectionSupport.singletonMap((Object)"u", (Object)this.principalName);
        }
        return super.getAuditFields(profileRequestContext);
    }
}

