/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class RevokeConsent
extends AbstractConsentIndexedStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RevokeConsent.class);
    private boolean maskStorageErrors;

    public void setMaskStorageErrors(boolean flag) {
        this.checkSetterPreconditions();
        this.maskStorageErrors = flag;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        block5: {
            String context = this.getStorageContext();
            String key = this.getStorageKey();
            StorageService service = this.getStorageService();
            assert (context != null && key != null && service != null);
            this.log.debug("{} Attempting to delete consent storage record with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), context, key});
            try {
                boolean success = service.delete(context, key);
                if (success) {
                    this.log.debug("{} Deleted consent storage record with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), context, key});
                } else {
                    this.log.debug("{} No consent storage record found with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), context, key});
                }
                this.removeKeyFromStorageIndex(key);
            }
            catch (IOException e) {
                this.log.error("{} Unable to delete consent storage record with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), context, key, e});
                if (this.maskStorageErrors) break block5;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }
}

