/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CreateResult
extends AbstractConsentIndexedStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CreateResult.class);

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        ConsentContext context = this.getConsentContext();
        assert (context != null);
        if (context.getCurrentConsents().isEmpty()) {
            this.log.debug("{} No result will be created because there are no current consents", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        ConsentContext consentContext = this.getConsentContext();
        ConsentFlowDescriptor flowDescriptor = this.getConsentFlowDescriptor();
        String storageContext = this.getStorageContext();
        String storageKey = this.getStorageKey();
        assert (consentContext != null && flowDescriptor != null && storageContext != null && storageKey != null);
        try {
            Map currentConsents = consentContext.getCurrentConsents();
            String value = this.getStorageSerializer().serialize((Object)currentConsents);
            Duration lifetime = flowDescriptor.getLifetime(profileRequestContext);
            Instant expiration = lifetime == null ? null : Instant.now().plus(lifetime);
            ConsentResult result = new ConsentResult(storageContext, storageKey, value, expiration);
            this.log.debug("{} Created consent result '{}'", (Object)this.getLogPrefix(), (Object)result);
            this.storeResultWithIndex(profileRequestContext, (ProfileInterceptorResult)result);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to serialize consent", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

