/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CreateGlobalConsentResult
extends AbstractConsentIndexedStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CreateGlobalConsentResult.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            Consent globalConsent = new Consent();
            globalConsent.setId("*");
            globalConsent.setApproved(true);
            String value = this.getStorageSerializer().serialize((Object)CollectionSupport.singletonMap((Object)globalConsent.ensureId(), (Object)globalConsent));
            ConsentFlowDescriptor flowDescriptor = this.getConsentFlowDescriptor();
            String storageContext = this.getStorageContext();
            String storageKey = this.getStorageKey();
            assert (flowDescriptor != null && storageContext != null && storageKey != null);
            Duration lifetime = flowDescriptor.getLifetime(profileRequestContext);
            Instant expiration = lifetime == null ? null : Instant.now().plus(lifetime);
            ConsentResult result = new ConsentResult(storageContext, storageKey, value, expiration);
            this.log.debug("{} Created global consent result '{}'", (Object)this.getLogPrefix(), (Object)result);
            this.storeResultWithIndex(profileRequestContext, (ProfileInterceptorResult)result);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to serialize consent", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

