/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ConsentFlowDescriptor
extends ProfileInterceptorFlowDescriptor {
    private boolean compareValues;
    @Nullable
    private Function<ProfileRequestContext, Duration> lifetimeLookupStrategy = FunctionSupport.constant(null);
    private int maxStoredRecords;
    private int expandedMaxStoredRecords;
    private long expandedStorageThreshold = 0x100000L;

    public boolean compareValues() {
        return this.compareValues;
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    @Nullable
    public Duration getLifetime() {
        return this.lifetimeLookupStrategy.apply(null);
    }

    @Nullable
    public Duration getLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        return this.lifetimeLookupStrategy.apply(profileRequestContext);
    }

    public int getMaximumNumberOfStoredRecords() {
        return this.maxStoredRecords;
    }

    public int getExpandedNumberOfStoredRecords() {
        return this.expandedMaxStoredRecords;
    }

    public long getExpandedStorageThreshold() {
        return this.expandedStorageThreshold;
    }

    public void setCompareValues(boolean flag) {
        this.checkSetterPreconditions();
        this.compareValues = flag;
    }

    public void setLifetime(@Nullable Duration consentLifetime) {
        this.checkSetterPreconditions();
        this.lifetimeLookupStrategy = FunctionSupport.constant((Object)consentLifetime);
    }

    public void setLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.lifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lifetime lookup strategy cannot be null");
    }

    public void setMaximumNumberOfStoredRecords(int maximum) {
        this.checkSetterPreconditions();
        this.maxStoredRecords = maximum;
    }

    public void setExpandedNumberOfStoredRecords(int maximum) {
        this.checkSetterPreconditions();
        this.expandedMaxStoredRecords = maximum;
    }

    public void setExpandedStorageThreshold(long size) {
        this.checkSetterPreconditions();
        this.expandedStorageThreshold = size;
    }
}

