/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.scripted.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.scripted.impl.ScriptedSearch;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;

public class ScriptedSearchBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<ScriptedSearch> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedSearchBuilder.class);
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nullable
    private Template cacheKeyTemplate;
    @NonnullAfterInit
    private String cacheKeyTemplateText;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        VelocityEngine localEngine = this.engine;
        if (null == localEngine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null != this.cacheKeyTemplateText) {
            this.cacheKeyTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)this.cacheKeyTemplateText);
        }
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        this.checkSetterPreconditions();
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    @Nullable
    public String getCacheKeyTemplateText() {
        return this.cacheKeyTemplateText;
    }

    public void setCacheKeyTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.cacheKeyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @Nonnull
    public ScriptedSearch build(final @Nonnull AttributeResolutionContext resolutionContext, final @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        return new ScriptedSearch(){

            @Override
            @Nonnull
            public AttributeResolutionContext getResolutionContext() {
                return resolutionContext;
            }

            @Nullable
            @NotEmpty
            public String getResultCacheKey() {
                return ScriptedSearchBuilder.this.getResultCacheKey(resolutionContext, dependencyAttributes);
            }
        };
    }

    @Nullable
    @NotEmpty
    private String getResultCacheKey(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) {
        Template ckt = this.cacheKeyTemplate;
        if (ckt == null) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating cache key using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        return ckt.merge((Context)context);
    }
}

