/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.util.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.slf4j.Logger;

public class DecryptionProcessor
extends AbstractInitializableComponent {
    private Logger log = LoggerFactory.getLogger(DecryptionProcessor.class);
    @NonnullAfterInit
    private DecryptionParametersResolver decryptionParamsResolver;
    @NonnullAfterInit
    private Function<ResponseData, List<DecryptionConfiguration>> decryptionConfigurationLookupStrategy;

    @NonnullAfterInit
    public DecryptionParametersResolver getDecryptionParametersResolver() {
        return this.decryptionParamsResolver;
    }

    public void setDecryptionParametersResolver(@Nonnull DecryptionParametersResolver resolver) {
        this.checkSetterPreconditions();
        this.decryptionParamsResolver = resolver;
    }

    @NonnullAfterInit
    public Function<ResponseData, List<DecryptionConfiguration>> getDecryptionConfigurationLookupStrategy() {
        return this.decryptionConfigurationLookupStrategy;
    }

    public void setDecryptionConfigurationLookupStrategy(@Nonnull Function<ResponseData, List<DecryptionConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.decryptionConfigurationLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.getDecryptionConfigurationLookupStrategy() == null) {
            throw new ComponentInitializationException("DecryptionConfiguration lookup strategy was null");
        }
        if (this.getDecryptionParametersResolver() == null) {
            throw new ComponentInitializationException("DecryptionParametersResolver was null");
        }
    }

    public boolean haveEncryptedAssertions(@Nonnull Response response) {
        return response.getEncryptedAssertions().size() > 0;
    }

    public boolean haveEncryptedContent(@Nonnull Response response) {
        for (Assertion assertion : response.getAssertions()) {
            Subject subject = assertion.getSubject();
            if (subject != null && subject.getEncryptedID() != null) {
                return true;
            }
            for (AttributeStatement statement : assertion.getAttributeStatements()) {
                if (statement.getEncryptedAttributes().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void decryptAssertions(@Nonnull Response response, @Nonnull Decrypter decrypter) {
        this.checkComponentActive();
        ArrayList<Assertion> decrypteds = new ArrayList<Assertion>();
        ArrayList<EncryptedAssertion> encrypteds = new ArrayList<EncryptedAssertion>();
        Iterator i = response.getEncryptedAssertions().iterator();
        while (i.hasNext()) {
            this.log.debug("Decrypting EncryptedAssertion in Response");
            try {
                EncryptedAssertion encrypted = (EncryptedAssertion)i.next();
                assert (encrypted != null);
                Assertion decrypted = decrypter.decrypt(encrypted);
                if (decrypted == null) continue;
                encrypteds.add(encrypted);
                decrypteds.add(decrypted);
            }
            catch (DecryptionException e) {
                this.log.warn("Error decrypting EncryptedAssertion, will not be processed for attribute extraction", (Throwable)e);
            }
        }
        response.getEncryptedAssertions().removeAll(encrypteds);
        response.getAssertions().addAll(decrypteds);
        if (!decrypteds.isEmpty()) {
            try {
                XMLObjectSupport.marshall((XMLObject)response);
            }
            catch (MarshallingException e) {
                this.log.warn("Error re-marshalling Response after Assertion decryption", (Throwable)e);
            }
        }
    }

    public void decryptAssertionContent(@Nonnull Response response, @Nonnull Decrypter decrypter) {
        ArrayList<Assertion> toRemove = new ArrayList<Assertion>();
        for (Assertion assertion : response.getAssertions()) {
            if (assertion == null) continue;
            try {
                this.decryptEncryptedIDs(assertion, decrypter);
            }
            catch (DecryptionException e) {
                this.log.warn("Error decrypting EncryptedIDs in Assertion '{}', will not be processed for attribute extraction", (Object)assertion.getID(), (Object)e);
                toRemove.add(assertion);
                continue;
            }
            this.decryptEncryptedAttributes(assertion, decrypter);
            response.getAssertions().removeAll(toRemove);
        }
    }

    public void decryptEncryptedIDs(@Nonnull Assertion assertion, @Nonnull Decrypter decrypter) throws DecryptionException {
        this.checkComponentActive();
        Subject subject = assertion.getSubject();
        if (subject != null) {
            EncryptedID encID = subject.getEncryptedID();
            if (encID != null) {
                this.log.debug("Decrypting EncryptedID in Subject");
                NameID decrypted = this.decryptEncryptedID(encID, decrypter);
                subject.setNameID(decrypted);
                subject.setEncryptedID(null);
            }
            for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                encID = sc.getEncryptedID();
                if (encID == null) continue;
                this.log.debug("Decrypting EncryptedID in SubjectConfirmation");
                NameID decrypted = this.decryptEncryptedID(encID, decrypter);
                sc.setNameID(decrypted);
                sc.setEncryptedID(null);
            }
        }
    }

    @Nonnull
    public NameID decryptEncryptedID(@Nonnull EncryptedID encID, @Nonnull Decrypter decrypter) throws DecryptionException {
        this.checkComponentActive();
        SAMLObject object = decrypter.decrypt(encID);
        if (object instanceof NameID) {
            return (NameID)object;
        }
        throw new DecryptionException("Decrypted EncryptedID was not a NameID, was a " + object.getElementQName().toString());
    }

    public void decryptEncryptedAttributes(@Nonnull Assertion assertion, @Nonnull Decrypter decrypter) {
        this.checkComponentActive();
        for (AttributeStatement s : assertion.getAttributeStatements()) {
            ArrayList<Attribute> decrypteds = new ArrayList<Attribute>();
            ArrayList<EncryptedAttribute> encrypteds = new ArrayList<EncryptedAttribute>();
            Iterator i = s.getEncryptedAttributes().iterator();
            while (i.hasNext()) {
                this.log.debug("Decrypting EncryptedAttribute in AttributeStatement");
                try {
                    EncryptedAttribute encrypted = (EncryptedAttribute)i.next();
                    assert (encrypted != null);
                    Attribute decrypted = decrypter.decrypt(encrypted);
                    if (decrypted == null) continue;
                    encrypteds.add(encrypted);
                    decrypteds.add(decrypted);
                }
                catch (DecryptionException e) {
                    this.log.warn("Error decrypting EncryptedAttribute, will not be processed for attribute extraction", (Throwable)e);
                }
            }
            s.getEncryptedAttributes().removeAll(encrypteds);
            s.getAttributes().addAll(decrypteds);
        }
    }

    @Nonnull
    public Decrypter buildDecrypter(@Nonnull ResponseData responseData) throws DecryptionException {
        this.checkComponentActive();
        List<DecryptionConfiguration> configs = this.getDecryptionConfigurationLookupStrategy().apply(responseData);
        if (configs == null || configs.isEmpty()) {
            this.log.error("No DecryptionConfigurations returned by lookup strategy");
            throw new DecryptionException("No DecryptionConfigurations returned by lookup strategy");
        }
        try {
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new DecryptionConfigurationCriterion(configs)});
            DecryptionParameters params = (DecryptionParameters)this.getDecryptionParametersResolver().resolveSingle((Object)criteria);
            this.log.debug("{} DecryptionParameters", (Object)(params != null ? "Resolved" : "Failed to resolve"));
            if (params != null) {
                return new Decrypter(params);
            }
            throw new DecryptionException("Failed to resolve DecryptionParameters");
        }
        catch (ResolverException e) {
            throw new DecryptionException("Error resolving DecryptionParameters", (Exception)((Object)e));
        }
    }
}

