/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.slf4j.Logger;

public class ConnectionFactoryValidator
implements Validator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ConnectionFactoryValidator.class);
    private boolean throwOnValidateError;

    public void setThrowValidateError(boolean what) {
        this.throwOnValidateError = what;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    public void validate(@Nonnull DataConnector dataConnector) throws ValidationException {
        block16: {
            if (!(dataConnector instanceof LDAPDataConnector)) {
                throw new ValidationException("DataConnector must be of type LDAPDataConnector");
            }
            ConnectionFactory connectionFactory = ((LDAPDataConnector)dataConnector).getConnectionFactory();
            if (connectionFactory == null) {
                this.log.error("No connection factory installed");
                if (this.isThrowValidateError()) {
                    throw new ValidationException("Connection factory is not set");
                }
            } else {
                assert (connectionFactory != null);
                try (Connection connection = connectionFactory.getConnection();){
                    if (connection == null) {
                        this.log.error("Unable to retrieve connections from configured connection factory");
                        if (this.isThrowValidateError()) {
                            throw new LdapException("Unable to retrieve connection from connection factory");
                        }
                    } else {
                        connection.open();
                    }
                }
                catch (LdapException e) {
                    this.log.error("Connection factory validation failed", (Throwable)e);
                    if (!this.isThrowValidateError()) break block16;
                    throw new ValidationException((Exception)((Object)e));
                }
            }
        }
    }
}

