/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class SetRPUIInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetRPUIInformation.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new SAMLMetadataContextLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyUIContext> rpUIContextCreateStrategy;
    @Nullable
    private List<String> fallbackLanguages;
    @NonnullBeforeExec
    private EntityDescriptor entityDescriptor;
    @Nullable
    private SPSSODescriptor spSSODescriptor;
    @Nullable
    private AttributeConsumingService acsDesriptor;

    public SetRPUIInformation() {
        Function rccs = new ChildContextLookup(RelyingPartyUIContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class, true));
        assert (rccs != null);
        this.rpUIContextCreateStrategy = rccs;
    }

    @Nonnull
    public Function<ProfileRequestContext, SAMLMetadataContext> getMetadataContextLookupStrategy() {
        return this.metadataContextLookupStrategy;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strgy) {
        this.checkSetterPreconditions();
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    public Function<ProfileRequestContext, RelyingPartyUIContext> getRPUIContextCreateStrategy() {
        return this.rpUIContextCreateStrategy;
    }

    public void setRPUIContextCreateStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyUIContext> strategy) {
        this.checkSetterPreconditions();
        this.rpUIContextCreateStrategy = (Function)Constraint.isNotNull(strategy, (String)"Injected RPUI Strategy cannot be null");
    }

    public void setFallbackLanguages(@Nonnull List<String> langs) {
        this.checkSetterPreconditions();
        this.fallbackLanguages = List.copyOf(StringSupport.normalizeStringCollection(langs));
    }

    @Nullable
    protected UIInfo getRPUInfo() {
        Extensions exts;
        if (this.spSSODescriptor != null && (exts = this.spSSODescriptor.getExtensions()) != null) {
            List children = (List)Constraint.isNotNull((Object)exts.getOrderedChildren(), (String)"Extension Object had no children");
            for (XMLObject object : children) {
                if (!(object instanceof UIInfo)) continue;
                return (UIInfo)object;
            }
        }
        return null;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeConsumingServiceContext acsCtx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SAMLMetadataContext metadataContext = this.metadataContextLookupStrategy.apply(profileRequestContext);
        if (null == metadataContext) {
            return false;
        }
        this.entityDescriptor = metadataContext.getEntityDescriptor();
        if (null == this.entityDescriptor) {
            return false;
        }
        RoleDescriptor roleDescriptor = metadataContext.getRoleDescriptor();
        if (roleDescriptor instanceof SPSSODescriptor) {
            this.spSSODescriptor = (SPSSODescriptor)roleDescriptor;
        }
        if (null != (acsCtx = (AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class))) {
            this.acsDesriptor = acsCtx.getAttributeConsumingService();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyUIContext rpUIContext = this.rpUIContextCreateStrategy.apply(profileRequestContext);
        if (rpUIContext == null) {
            this.log.error("{} Unable to create RelyingPartyUIContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        if (null != this.fallbackLanguages) {
            rpUIContext.setFallbackLanguages(this.fallbackLanguages);
        }
        rpUIContext.setRPEntityDescriptor(this.entityDescriptor);
        rpUIContext.setRPSPSSODescriptor(this.spSSODescriptor);
        rpUIContext.setRPAttributeConsumingService(this.acsDesriptor);
        rpUIContext.setRPUInfo(this.getRPUInfo());
        HttpServletRequest request = this.getHttpServletRequest();
        NonnullSupplier supplier = this.getHttpServletRequestSupplier();
        assert (request != null && supplier != null);
        rpUIContext.setBrowserLanguageRanges(SpringSupport.getLanguageRange((HttpServletRequest)request));
        rpUIContext.setRequestSupplier((NonnullSupplier<HttpServletRequest>)supplier);
    }
}

