/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.factory.FlowDefinitionResourceFactory;
import net.shibboleth.idp.profile.spring.factory.FlowModelFlowBuilder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistryImpl;
import org.springframework.webflow.engine.builder.DefaultFlowHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.support.FlowBuilderContextImpl;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.xml.XmlFlowModelBuilder;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.model.registry.FlowModelLocator;
import org.springframework.webflow.engine.model.registry.FlowModelRegistry;
import org.springframework.webflow.engine.model.registry.FlowModelRegistryImpl;

public class FlowDefinitionRegistryFactoryBean
extends AbstractFactoryBean<FlowDefinitionRegistry> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FlowDefinitionRegistryFactoryBean.class);
    @Nonnull
    private Map<String, String> flowLocations = CollectionSupport.emptyMap();
    @Nonnull
    private Map<String, String> flowLocationPatterns = CollectionSupport.emptyMap();
    @Nullable
    private FlowBuilderServices flowBuilderServices;
    @Nullable
    private String basePath;
    @Nullable
    private FlowDefinitionRegistry parent;

    public Class<?> getObjectType() {
        return FlowDefinitionRegistry.class;
    }

    public void setBasePath(@Nullable String path) {
        this.basePath = StringSupport.trimOrNull((String)path);
    }

    public void setFlowLocations(@Nonnull Map<String, String> locationMap) {
        Constraint.isNotNull(locationMap, (String)"Flow mappings cannot be null");
        this.flowLocations = new LinkedHashMap<String, String>(locationMap.size());
        for (Map.Entry<String, String> entry : locationMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.flowLocations.put(entry.getKey(), entry.getValue());
        }
    }

    public void setFlowLocationPatterns(@Nonnull Map<String, String> patternMap) {
        Constraint.isNotNull(patternMap, (String)"Pattern mappings cannot be null");
        this.flowLocationPatterns = new LinkedHashMap<String, String>(patternMap.size());
        for (Map.Entry<String, String> entry : patternMap.entrySet()) {
            if (entry.getKey() == null || this.basePath == null && entry.getValue() == null) continue;
            this.flowLocationPatterns.put(entry.getKey(), entry.getValue());
        }
    }

    public void setFlowBuilderServices(@Nonnull FlowBuilderServices builderServices) {
        this.flowBuilderServices = (FlowBuilderServices)Constraint.isNotNull((Object)builderServices, (String)"FlowBuilderServices cannot be null");
    }

    public void setParent(@Nullable FlowDefinitionRegistry parentRegistry) {
        this.parent = parentRegistry;
    }

    @Nonnull
    protected FlowDefinitionRegistry createInstance() throws Exception {
        if (this.flowBuilderServices == null) {
            throw new BeanCreationException("FlowBuilderServices instance was null");
        }
        assert (this.flowBuilderServices != null);
        ApplicationContext ac = this.flowBuilderServices.getApplicationContext();
        assert (ac != null);
        FlowDefinitionResourceFactory flowResourceFactory = new FlowDefinitionResourceFactory((ResourceLoader)ac);
        DefaultFlowRegistry flowRegistry = new DefaultFlowRegistry();
        flowRegistry.setParent(this.parent);
        this.registerFlowLocations(flowRegistry, flowResourceFactory);
        this.registerFlowLocationPatterns(flowRegistry, flowResourceFactory);
        return flowRegistry;
    }

    protected void destroyInstance(@Nullable FlowDefinitionRegistry instance) throws Exception {
        if (instance != null) {
            ((DefaultFlowRegistry)instance).destroy();
        }
    }

    private void registerFlowLocations(@Nonnull DefaultFlowRegistry flowRegistry, @Nonnull FlowDefinitionResourceFactory resourceFactory) {
        for (Map.Entry<String, String> location : this.flowLocations.entrySet()) {
            LocalAttributeMap attributes = new LocalAttributeMap();
            this.updateFlowAttributes((LocalAttributeMap<Object>)attributes);
            String value = location.getValue();
            String key = location.getKey();
            assert (value != null && key != null);
            FlowDefinitionResource resource = resourceFactory.createResource(this.basePath, value, (AttributeMap<Object>)attributes, key);
            this.registerFlow(resource, flowRegistry);
        }
    }

    private void registerFlowLocationPatterns(@Nonnull DefaultFlowRegistry flowRegistry, @Nonnull FlowDefinitionResourceFactory resourceFactory) {
        for (Map.Entry<String, String> pattern : this.flowLocationPatterns.entrySet()) {
            Collection<FlowDefinitionResource> resources;
            LocalAttributeMap attributes = new LocalAttributeMap();
            this.updateFlowAttributes((LocalAttributeMap<Object>)attributes);
            try {
                String base = pattern.getValue() != null ? pattern.getValue() : (this.basePath != null ? this.basePath : "");
                String key = pattern.getKey();
                assert (base != null && key != null);
                resources = resourceFactory.createResources(base, key, (AttributeMap<Object>)attributes);
            }
            catch (IOException e) {
                throw new IllegalStateException("An I/O Exception occurred resolving the flow location pattern '" + pattern.getKey() + "'", e);
            }
            HashSet<String> existingFlows = new HashSet<String>();
            Arrays.stream(flowRegistry.getFlowDefinitionIds()).forEachOrdered(existingFlows::add);
            for (FlowDefinitionResource resource : resources) {
                if (existingFlows.contains(resource.getId())) {
                    throw new IllegalStateException("Illegal attempt to register pre-existing flow ID '" + resource.getId() + "'via resource: " + String.valueOf(resource.getPath()));
                }
                this.registerFlow(resource, flowRegistry);
                existingFlows.add(resource.getId());
            }
        }
    }

    private void registerFlow(@Nonnull FlowDefinitionResource resource, @Nonnull DefaultFlowRegistry flowRegistry) {
        XmlFlowModelBuilder flowModelBuilder = null;
        String fname = resource.getPath().getFilename();
        if (fname == null || !fname.endsWith(".xml")) {
            throw new IllegalArgumentException(String.valueOf(resource) + " is not a supported resource type; supported types are [.xml]");
        }
        flowModelBuilder = new XmlFlowModelBuilder(resource.getPath(), (FlowModelLocator)flowRegistry.getFlowModelRegistry());
        DefaultFlowModelHolder flowModelHolder = new DefaultFlowModelHolder((FlowModelBuilder)flowModelBuilder);
        FlowModelFlowBuilder flowBuilder = new FlowModelFlowBuilder((FlowModelHolder)flowModelHolder);
        FlowBuilderContextImpl builderContext = new FlowBuilderContextImpl(resource.getId(), resource.getAttributes(), (FlowDefinitionLocator)flowRegistry, this.flowBuilderServices);
        FlowAssembler assembler = new FlowAssembler((FlowBuilder)flowBuilder, (FlowBuilderContext)builderContext);
        DefaultFlowHolder flowHolder = new DefaultFlowHolder(assembler);
        flowRegistry.getFlowModelRegistry().registerFlowModel(resource.getId(), (FlowModelHolder)flowModelHolder);
        flowRegistry.registerFlowDefinition((FlowDefinitionHolder)flowHolder);
        this.log.debug("Registered flow ID '{}' using '{}'", (Object)resource.getId(), (Object)resource.getPath());
    }

    private void updateFlowAttributes(@Nonnull LocalAttributeMap<Object> attributes) {
        if (this.flowBuilderServices != null && this.flowBuilderServices.getDevelopment()) {
            attributes.put("development", (Object)true);
        }
    }

    private static class DefaultFlowRegistry
    extends FlowDefinitionRegistryImpl {
        @Nonnull
        private FlowModelRegistry flowModelRegistry = new FlowModelRegistryImpl();

        private DefaultFlowRegistry() {
        }

        @Nonnull
        public FlowModelRegistry getFlowModelRegistry() {
            return this.flowModelRegistry;
        }

        public void setParent(@Nullable FlowDefinitionRegistry parent) {
            super.setParent(parent);
            if (parent instanceof DefaultFlowRegistry) {
                DefaultFlowRegistry parentFlowRegistry = (DefaultFlowRegistry)parent;
                this.flowModelRegistry.setParent(parentFlowRegistry.getFlowModelRegistry());
            }
        }
    }
}

