/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.slf4j.Logger;

public class ValidateSAMLAuthentication
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.saml";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateSAMLAuthentication.class);
    @Nullable
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nullable
    private ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Collection<IdPAttribute>> attributeExtractionStrategy;
    private boolean decodeNameID;
    private boolean acceptUnfilteredAttributes;
    @Nullable
    @NotEmpty
    private String loggedAttributeId;
    @NonnullBeforeExec
    private SAMLAuthnContext samlAuthnContext;
    @NonnullBeforeExec
    private BrowserSSOProfileConfiguration profileConfiguration;
    @Nullable
    private Function<AuthnContext, Collection<Principal>> authnContextTranslator;
    @Nullable
    private Function<ProfileRequestContext, Collection<Principal>> authnContextTranslatorEx;
    @Nullable
    private AttributeContext attributeContext;

    public ValidateSAMLAuthentication() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setTranscoderRegistry(@Nullable ReloadableService<AttributeTranscoderRegistry> registry) {
        this.checkSetterPreconditions();
        this.transcoderRegistry = registry;
    }

    public void setAttributeFilter(@Nullable ReloadableService<AttributeFilter> filterService) {
        this.checkSetterPreconditions();
        this.attributeFilterService = filterService;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.checkSetterPreconditions();
        this.metadataResolver = resolver;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAttributeExtractionStrategy(@Nullable Function<ProfileRequestContext, Collection<IdPAttribute>> strategy) {
        this.checkSetterPreconditions();
        this.attributeExtractionStrategy = strategy;
    }

    public void setDecodeNameID(boolean flag) {
        this.checkSetterPreconditions();
        this.decodeNameID = flag;
    }

    public void setAcceptUnfilteredAttributes(boolean flag) {
        this.checkSetterPreconditions();
        this.acceptUnfilteredAttributes = flag;
    }

    public void setLoggedAttributeId(@Nullable @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.loggedAttributeId = StringSupport.trimOrNull((String)id);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.samlAuthnContext = (SAMLAuthnContext)authenticationContext.getSubcontext(SAMLAuthnContext.class);
        if (this.samlAuthnContext == null) {
            this.log.debug("{} No SAMLAuthnContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return false;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.error("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (rpContext.getProfileConfig() == null) {
            this.log.error("{} Unable to locate profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!(rpContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration)) {
            this.log.error("{} Not a SAML 2 profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.profileConfiguration = (BrowserSSOProfileConfiguration)rpContext.getProfileConfig();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Function<ProfileRequestContext, Collection<IdPAttribute>> aes;
        this.recordSuccess(profileRequestContext);
        if (this.transcoderRegistry != null) {
            this.processAttributes(profileRequestContext);
        }
        if ((aes = this.attributeExtractionStrategy) != null) {
            this.log.debug("{} Applying custom extraction strategy function", (Object)this.getLogPrefix());
            Collection<IdPAttribute> newAttributes = aes.apply(profileRequestContext);
            if (newAttributes != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Extracted attributes with custom strategy: {}", (Object)this.getLogPrefix(), newAttributes.stream().map(IdPAttribute::getId).collect(Collectors.toUnmodifiableList()));
                }
                if (this.attributeContext != null) {
                    Map newMap = IdPAttributeSupport.toMapMergeDuplicates(newAttributes);
                    assert (this.attributeContext != null);
                    this.attributeContext.setIdPAttributes(IdPAttributeSupport.withMapMergeDuplicates((Map)newMap, (Map)this.attributeContext.getIdPAttributes()));
                } else {
                    this.attributeContext = (AttributeContext)((RelyingPartyContext)profileRequestContext.ensureSubcontext(RelyingPartyContext.class)).ensureSubcontext(AttributeContext.class);
                    this.attributeContext.setIdPAttributes(IdPAttributeSupport.toMapMergeDuplicates(newAttributes));
                }
            }
        }
        this.logSuccess();
        this.authnContextTranslator = this.profileConfiguration.getAuthnContextTranslationStrategy(profileRequestContext);
        this.authnContextTranslatorEx = this.profileConfiguration.getAuthnContextTranslationStrategyEx(profileRequestContext);
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        AuthenticationResult ar = authenticationContext.getAuthenticationResult();
        if (ar != null && this.profileConfiguration.isProxiedAuthnInstant(profileRequestContext)) {
            AuthnStatement as = this.samlAuthnContext.getAuthnStatement();
            assert (as != null);
            Instant ai = as.getAuthnInstant();
            assert (ai != null);
            this.log.debug("{} Resetting authentication time to proxied value: {}", (Object)this.getLogPrefix(), (Object)ai);
            if (as.getAuthnInstant() != null) {
                ar.setAuthenticationInstant(ai);
            }
        }
    }

    protected void logSuccess() {
        IdPAttribute attrToLog;
        String nameToLog = null;
        if (this.loggedAttributeId != null && this.attributeContext != null && (attrToLog = (IdPAttribute)this.attributeContext.getIdPAttributes().get(this.loggedAttributeId)) != null && !attrToLog.getValues().isEmpty()) {
            nameToLog = ((IdPAttributeValue)attrToLog.getValues().get(0)).getDisplayValue();
        }
        assert (this.samlAuthnContext != null);
        Subject samlSubject = this.samlAuthnContext.getSubject();
        if (nameToLog == null && samlSubject != null) {
            NameID id = samlSubject.getNameID();
            nameToLog = id != null ? id.getValue() : null;
        }
        this.log.info("{} SAML authentication succeeded for '{}'", (Object)this.getLogPrefix(), nameToLog);
    }

    @Nonnull
    protected javax.security.auth.Subject populateSubject(@Nonnull javax.security.auth.Subject subject) {
        Collection<Principal> translated;
        NameID nameID;
        SAMLAuthnContext localSamlAuthnContext = this.samlAuthnContext;
        AttributeContext localAttributeContext = this.attributeContext;
        assert (localSamlAuthnContext != null && localAttributeContext != null);
        BaseContext localSamlAuthnContextParent = localSamlAuthnContext.getParent();
        assert (localSamlAuthnContextParent != null);
        Subject samlSubject = localSamlAuthnContext.getSubject();
        NameID nameID2 = nameID = samlSubject == null ? null : samlSubject.getNameID();
        if (nameID != null) {
            subject.getPrincipals().add((Principal)new NameIDPrincipal(nameID));
        }
        AuthnStatement authnStatement = localSamlAuthnContext.getAuthnStatement();
        assert (authnStatement != null);
        AuthnContext authnContext = (AuthnContext)Constraint.isNotNull((Object)authnStatement.getAuthnContext(), (String)"No Authn Context");
        boolean principalsAdded = false;
        if (this.authnContextTranslatorEx != null && (translated = this.authnContextTranslatorEx.apply((ProfileRequestContext)localSamlAuthnContextParent.getSubcontext(ProfileRequestContext.class))) != null && !translated.isEmpty()) {
            subject.getPrincipals().addAll(translated);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Added translated Principals: {}", (Object)this.getLogPrefix(), translated.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
            principalsAdded = true;
        }
        if (!principalsAdded && this.authnContextTranslator != null && (translated = this.authnContextTranslator.apply(authnContext)) != null && !translated.isEmpty()) {
            subject.getPrincipals().addAll(translated);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Added translated AuthnContext Principals: {}", (Object)this.getLogPrefix(), translated.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
            principalsAdded = true;
        }
        if (!principalsAdded) {
            AuthnContextDeclRef acDecl;
            AuthnContextClassRef acClass = authnContext.getAuthnContextClassRef();
            if (acClass != null) {
                String classRef = acClass.getURI();
                if (classRef != null) {
                    subject.getPrincipals().add((Principal)new AuthnContextClassRefPrincipal(classRef));
                    this.log.debug("{} Added AuthnContextClassRef from assertion: {}", (Object)this.getLogPrefix(), (Object)classRef);
                }
                principalsAdded = true;
            }
            if ((acDecl = authnContext.getAuthnContextDeclRef()) != null) {
                String declRef = acDecl.getURI();
                if (declRef != null) {
                    subject.getPrincipals().add((Principal)new AuthnContextDeclRefPrincipal(declRef));
                    this.log.debug("{} Added AuthnContextDeclRef from assertion: {}", (Object)this.getLogPrefix(), (Object)declRef);
                }
                principalsAdded = true;
            }
        }
        if (!principalsAdded) {
            this.log.warn("{} No AuthnContext information usable from assertion", (Object)this.getLogPrefix());
        }
        subject.getPrincipals().add((Principal)this.buildProxyPrincipal(authnContext));
        if (localAttributeContext != null && !localAttributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} Adding filtered inbound attributes to Subject", (Object)this.getLogPrefix());
            subject.getPrincipals().addAll(localAttributeContext.getIdPAttributes().values().stream().map(a -> {
                assert (a != null);
                return new IdPAttributePrincipal(a);
            }).collect(Collectors.toUnmodifiableList()));
        }
        return subject;
    }

    @Nonnull
    private ProxyAuthenticationPrincipal buildProxyPrincipal(@Nonnull AuthnContext authnContext) {
        Conditions conditions;
        ProxyRestriction condition;
        Issuer issuer;
        ProxyAuthenticationPrincipal proxied = new ProxyAuthenticationPrincipal();
        assert (this.samlAuthnContext != null);
        AuthnStatement authnStatement = this.samlAuthnContext.getAuthnStatement();
        assert (authnStatement != null);
        Assertion assertion = (Assertion)authnStatement.getParent();
        assert (assertion != null);
        if (!authnContext.getAuthenticatingAuthorities().isEmpty()) {
            proxied.getAuthorities().addAll(authnContext.getAuthenticatingAuthorities().stream().map(XSURI::getURI).filter(aa -> !Strings.isNullOrEmpty((String)aa)).collect(Collectors.toUnmodifiableList()));
        }
        if ((issuer = assertion.getIssuer()) != null) {
            proxied.getAuthorities().add(issuer.getValue());
        }
        ProxyRestriction proxyRestriction = condition = (conditions = assertion.getConditions()) != null ? conditions.getProxyRestriction() : null;
        if (condition != null) {
            proxied.setProxyCount(condition.getProxyCount());
            List audiences = condition.getAudiences();
            if (audiences != null) {
                proxied.getAudiences().addAll(audiences.stream().map(XSURI::getURI).filter(a -> !Strings.isNullOrEmpty((String)a)).collect(Collectors.toUnmodifiableList()));
            }
        }
        return proxied;
    }

    private void processAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Decoding incoming SAML Attributes", (Object)this.getLogPrefix());
        HashMultimap mapped = HashMultimap.create();
        assert (mapped != null);
        assert (this.transcoderRegistry != null);
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            MessageContext imc = profileRequestContext.getInboundMessageContext();
            assert (imc != null);
            Response response = (Response)imc.getMessage();
            assert (response != null);
            for (Assertion assertion : response.getAssertions()) {
                NameID nameid;
                Subject subject;
                if (this.decodeNameID && (subject = assertion.getSubject()) != null && (nameid = subject.getNameID()) != null) {
                    try {
                        this.decodeNameID((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, nameid, (Multimap<String, IdPAttribute>)mapped);
                    }
                    catch (AttributeDecodingException e) {
                        this.log.error("{} Error decoding inbound NameID", (Object)this.getLogPrefix(), (Object)e);
                    }
                }
                for (AttributeStatement statement : assertion.getAttributeStatements()) {
                    for (Attribute designator : statement.getAttributes()) {
                        assert (designator != null);
                        try {
                            this.decodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, (Multimap<String, IdPAttribute>)mapped);
                        }
                        catch (AttributeDecodingException e) {
                            this.log.error("{} Error decoding inbound Attribute", (Object)this.getLogPrefix(), (Object)e);
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            this.log.error("Attribute transcoder service unavailable", (Throwable)e);
            return;
        }
        this.log.debug("{} Incoming SAML Attributes mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        if (!mapped.isEmpty()) {
            RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
            assert (rpCtx != null);
            this.attributeContext = (AttributeContext)rpCtx.ensureSubcontext(AttributeContext.class);
            this.attributeContext.setUnfilteredIdPAttributes(IdPAttributeSupport.toMapMergeDuplicates((Collection)mapped.values())).setIdPAttributes((Map)null);
            this.filterAttributes(profileRequestContext);
        }
    }

    private void decodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} No transcoding rule for Attribute (Name '{}', NameFormat: '{}')", new Object[]{this.getLogPrefix(), input.getName(), input.getNameFormat()});
            return;
        }
        for (TranscodingRule rule : transcodingRules) {
            assert (rule != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rule);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    private void decodeNameID(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull NameID input, @Nonnull @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} No transcoding rule for NameID (Format: '{}')", (Object)this.getLogPrefix(), (Object)input.getFormat());
            return;
        }
        for (TranscodingRule rule : transcodingRules) {
            assert (rule != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rule);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        ReloadableService<AttributeFilter> service = this.attributeFilterService;
        if (service == null) {
            this.log.warn("{} No AttributeFilter service provided", (Object)this.getLogPrefix());
            return;
        }
        AttributeFilterContext filterContext = (AttributeFilterContext)profileRequestContext.ensureSubcontext(AttributeFilterContext.class);
        this.populateFilterContext(profileRequestContext, filterContext);
        try (ServiceableComponent component = service.getServiceableComponent();){
            AttributeFilter filter = (AttributeFilter)component.getComponent();
            filter.filterAttributes(filterContext);
            assert (this.attributeContext != null);
            this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes());
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error while filtering inbound attributes", (Object)this.getLogPrefix(), (Object)e);
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid AttributeFilter configuration", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            filterContext.removeFromParent();
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        AttributeContext ac = this.attributeContext;
        assert (ac != null);
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(ac.getUnfilteredIdPAttributes()).setIncludeUnfilteredAttributes(this.acceptUnfilteredAttributes).setMetadataResolver(this.metadataResolver).setRequesterMetadataContextLookupStrategy(null).setIssuerMetadataContextLookupStrategy(new SAMLMetadataContextLookupFunction().compose((Function)new RecursiveTypedParentContextLookup(ProfileRequestContext.class))).setProxiedRequesterContextLookupStrategy(null).setAttributeIssuerID((String)((Function)Constraint.isNotNull((Object)this.getResponderLookupStrategy(), (String)"No responder Strategy")).apply(profileRequestContext)).setAttributeRecipientID((String)((Function)Constraint.isNotNull((Object)this.getRequesterLookupStrategy(), (String)"No requester strategy")).apply(profileRequestContext));
    }
}

