/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml1.profile.config.impl.AbstractSAML1AssertionProducingProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class AttributeQueryProfileConfiguration
extends AbstractSAML1AssertionProducingProfileConfiguration
implements net.shibboleth.saml.saml1.profile.config.AttributeQueryProfileConfiguration,
SAMLAssertionProducingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml1.query.attribute";
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> requestedIdPAttributeNamesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> attributeRecipientGroupIDLookupStrategy;

    public AttributeQueryProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml1/query/attribute");
    }

    protected AttributeQueryProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.requestedIdPAttributeNamesLookupStrategy = FunctionSupport.constant(null);
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return true;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getRequestedIdPAttributeNames(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> names = this.requestedIdPAttributeNamesLookupStrategy.apply(profileRequestContext);
        if (names != null) {
            return CollectionSupport.copyToSet(names);
        }
        return CollectionSupport.emptySet();
    }

    public void setRequestedIdPAttributeNames(@Nullable Collection<String> names) {
        this.requestedIdPAttributeNamesLookupStrategy = names == null || names.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names)));
    }

    public void setRequestedIdPAttributeNamesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.requestedIdPAttributeNamesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requested IdPAttribute names lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeRecipientGroupID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeRecipientGroupIDLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeRecipientGroupID(@Nullable String groupID) {
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant((Object)groupID);
    }

    public void setAttributeRecipientGroupIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeRecipientGroupIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Group ID lookup strategy cannot be null");
    }
}

