/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;

public class UpdateSAMLSelfEntityContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateSAMLSelfEntityContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new IssuerLookupFunction();
    @Nullable
    private String selfIdentity;

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.selfIdentity = this.selfIdentityLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLSelfEntityContext context;
        MessageContext omc;
        SAMLSelfEntityContext context2;
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        if (imc != null && (context2 = (SAMLSelfEntityContext)imc.getSubcontext(SAMLSelfEntityContext.class)) != null && !Objects.equals(context2.getEntityId(), this.selfIdentity)) {
            this.log.debug("{} Updating inbound SAMLSelfEntityContext, '{}' to '{}'", new Object[]{this.getLogPrefix(), context2.getEntityId(), this.selfIdentity});
            context2.setEntityId(this.selfIdentity);
        }
        if ((omc = profileRequestContext.getOutboundMessageContext()) != null && (context = (SAMLSelfEntityContext)omc.getSubcontext(SAMLSelfEntityContext.class)) != null && !Objects.equals(context.getEntityId(), this.selfIdentity)) {
            this.log.debug("{} Updating outbound SAMLSelfEntityContext, '{}' to '{}'", new Object[]{this.getLogPrefix(), context.getEntityId(), this.selfIdentity});
            context.setEntityId(this.selfIdentity);
        }
    }
}

