/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.slf4j.Logger;

@NotThreadSafe
public abstract class BaseIdPInitiatedSSORequestMessageDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    @NotEmpty
    public static final String PROVIDER_ID_PARAM = "providerId";
    @Nonnull
    @NotEmpty
    public static final String SHIRE_PARAM = "shire";
    @Nonnull
    @NotEmpty
    public static final String TARGET_PARAM = "target";
    @Nonnull
    @NotEmpty
    public static final String TIME_PARAM = "time";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseIdPInitiatedSSORequestMessageDecoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;
    @Nonnull
    private final IdentifierGenerationStrategy idGenerator = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.UUID);

    public BaseIdPInitiatedSSORequestMessageDecoder() {
        this.setProtocolMessageLoggerSubCategory("SAML");
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpServletRequest");
        super.decode();
        this.log.debug("Successfully decoded message from HttpServletRequest.");
    }

    @Nonnull
    protected IdPInitiatedSSORequest buildIdPInitiatedSSORequest() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        return new IdPInitiatedSSORequest(this.getEntityId(request), this.getAcsUrl(request), this.getTarget(request), this.getTime(request));
    }

    @Nonnull
    @NotEmpty
    protected String getEntityId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String entityId = StringSupport.trimOrNull((String)request.getParameter(PROVIDER_ID_PARAM));
        if (entityId == null) {
            throw new MessageDecodingException("Shibboleth Authentication Request message did not contain the providerId query parameter.");
        }
        return entityId;
    }

    @Nullable
    protected String getAcsUrl(@Nonnull HttpServletRequest request) {
        return StringSupport.trimOrNull((String)request.getParameter(SHIRE_PARAM));
    }

    @Nullable
    protected String getTarget(@Nonnull HttpServletRequest request) {
        return StringSupport.trimOrNull((String)request.getParameter(TARGET_PARAM));
    }

    @Nullable
    protected Instant getTime(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String timeString = StringSupport.trimOrNull((String)request.getParameter(TIME_PARAM));
        if (timeString == null) {
            return null;
        }
        try {
            long time = Long.parseLong(timeString);
            if (time < 0L) {
                throw new MessageDecodingException("Shibboleth Authentication Request contained a negative time value");
            }
            return Instant.ofEpochSecond(time);
        }
        catch (NumberFormatException e) {
            throw new MessageDecodingException("Shibboleth Authentication Request contained a non-numeric time value");
        }
    }

    @Nonnull
    protected String getMessageID() {
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        String timeString = StringSupport.trimOrNull((String)request.getParameter(TIME_PARAM));
        if (timeString != null) {
            String sessionID = request.getRequestedSessionId();
            if (sessionID != null) {
                return "_" + sessionID + "!" + timeString;
            }
            return this.idGenerator.generateIdentifier();
        }
        return this.idGenerator.generateIdentifier();
    }
}

