/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.AbstractSAML1NameIdentifierGenerator;
import org.opensaml.saml.saml1.profile.SAML1ObjectSupport;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class AttributeSourcedSAML1NameIdentifierGenerator
extends AbstractSAML1NameIdentifierGenerator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedSAML1NameIdentifierGenerator.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    private boolean useUnfilteredAttributes;
    private char delimiter;
    @Nonnull
    private List<String> attributeSourceIds;

    public AttributeSourcedSAML1NameIdentifierGenerator() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
        this.delimiter = (char)64;
        this.attributeSourceIds = CollectionSupport.emptyList();
        this.setDefaultIdPNameQualifierLookupStrategy((Function)new IssuerLookupFunction());
        this.setDefaultSPNameQualifierLookupStrategy((Function)new RelyingPartyIdLookupFunction());
        this.useUnfilteredAttributes = false;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setScopedDelimiter(char ch) {
        this.checkSetterPreconditions();
        this.delimiter = ch;
    }

    public void setAttributeSourceIds(@Nonnull List<String> ids) {
        this.checkSetterPreconditions();
        this.attributeSourceIds = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(ids, (String)"Attribute ID collection cannot be null")));
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
    }

    @Nullable
    protected NameIdentifier doGenerate(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (attributeCtx == null) {
            this.log.warn("Unable to locate AttributeContext");
            return null;
        }
        Map attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                XMLObject xmlObject;
                if (!(value instanceof XMLObjectAttributeValue) || !((xmlObject = ((XMLObjectAttributeValue)value).getValue()) instanceof NameIdentifier)) continue;
                NameIdentifier nameIdentifier = (NameIdentifier)xmlObject;
                if (SAML1ObjectSupport.areNameIdentifierFormatsEquivalent((String)this.getFormat(), (String)nameIdentifier.getFormat())) {
                    this.log.info("Returning NameIdentifier from XMLObject-valued attribute {}", (Object)sourceId);
                    return nameIdentifier;
                }
                this.log.debug("Attribute {} value was NameIdentifier, but Format did not match", (Object)sourceId);
            }
        }
        return super.doGenerate(profileRequestContext);
    }

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        Map attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            this.log.debug("Checking for source attribute {}", (Object)sourceId);
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                if (value instanceof ScopedStringAttributeValue) {
                    this.log.debug("Generating NameIdentifier from Scoped String-valued attribute {}", (Object)sourceId);
                    return ((ScopedStringAttributeValue)value).getValue() + this.delimiter + ((ScopedStringAttributeValue)value).getScope();
                }
                if (value instanceof StringAttributeValue) {
                    String strVal = StringSupport.trimOrNull((String)((StringAttributeValue)value).getValue());
                    if (strVal == null) {
                        this.log.debug("Skipping all-whitespace string value");
                        continue;
                    }
                    this.log.debug("Generating NameIdentifier from String-valued attribute {}", (Object)sourceId);
                    return strVal;
                }
                if (value instanceof EmptyAttributeValue) {
                    this.log.debug("Skipping empty value");
                    continue;
                }
                this.log.warn("Unrecognized attribute value type: {}", (Object)value.getClass().getName());
            }
        }
        this.log.info("Attribute sources {} did not produce a usable identifier", this.attributeSourceIds);
        return null;
    }
}

