/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.messaging.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.binding.impl.SAMLAddAttributeConsumingServiceHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;

public class AddAttributeConsumingServiceHandler
extends SAMLAddAttributeConsumingServiceHandler {
    @Nonnull
    private Function<MessageContext, ProfileRequestContext> profileRequestContextLookupStrategy = new ParentContextLookup(ProfileRequestContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<MessageContext, ProfileRequestContext> strategy) {
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected Collection<RequestedAttribute> getRequestedAttributes(@Nonnull MessageContext messageContext, @Nonnull AuthnRequest authn) {
        BrowserSSOProfileConfiguration sso;
        Collection attrs;
        ProfileConfiguration profileConfiguration;
        ProfileRequestContext prc = this.profileRequestContextLookupStrategy.apply(messageContext);
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(prc);
        if (rpContext != null && (profileConfiguration = rpContext.getProfileConfig()) instanceof BrowserSSOProfileConfiguration && !(attrs = (sso = (BrowserSSOProfileConfiguration)profileConfiguration).getRequestedAttributes(prc)).isEmpty()) {
            ArrayList<RequestedAttribute> copy = new ArrayList<RequestedAttribute>();
            copy.addAll(attrs);
            attrs = super.getRequestedAttributes(messageContext, authn);
            if (attrs != null) {
                copy.addAll(attrs);
            }
            return copy;
        }
        return super.getRequestedAttributes(messageContext, authn);
    }
}

