/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class ReloadableMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadableMetadataResolver.class);
    @Nonnull
    private final ReloadableService<MetadataResolver> service;

    public ReloadableMetadataResolver(@Nonnull @ParameterName(name="resolverService") ReloadableService<MetadataResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"MetadataResolver Service cannot be null");
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            Iterable iterable;
            block9: {
                this.checkComponentActive();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    iterable = ((MetadataResolver)component.getComponent()).resolve((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("ReloadableMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("ReloadableMetadataResolver '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId(), (Object)e);
                    }
                }
                component.close();
            }
            return iterable;
        }
        return CollectionSupport.emptySet();
    }

    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            EntityDescriptor entityDescriptor;
            block9: {
                this.checkComponentActive();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    entityDescriptor = (EntityDescriptor)((MetadataResolver)component.getComponent()).resolveSingle((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("ReloadableMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("ReloadableMetadataResolver '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId(), (Object)e);
                    }
                }
                component.close();
            }
            return entityDescriptor;
        }
        return null;
    }

    public boolean isRequireValidMetadata() {
        boolean bl;
        block8: {
            this.checkComponentActive();
            ServiceableComponent component = this.service.getServiceableComponent();
            try {
                bl = ((MetadataResolver)component.getComponent()).isRequireValidMetadata();
                if (component == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceException e) {
                    this.log.error("ReloadableMetadataResolver '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId(), (Object)e);
                    throw e;
                }
            }
            component.close();
        }
        return bl;
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new IllegalAccessError("Cannot set RequireValidMetadata");
    }

    @Nullable
    public MetadataFilter getMetadataFilter() {
        MetadataFilter metadataFilter;
        block8: {
            this.checkComponentActive();
            ServiceableComponent component = this.service.getServiceableComponent();
            try {
                metadataFilter = ((MetadataResolver)component.getComponent()).getMetadataFilter();
                if (component == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceException e) {
                    this.log.error("ReloadableMetadataResolver '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId(), (Object)e);
                    throw e;
                }
            }
            component.close();
        }
        return metadataFilter;
    }

    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Cannot set Metadata filter");
    }

    @Nullable
    public String getType() {
        return null;
    }
}

