/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resource.Resource;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.impl.LogoBuilder;
import org.opensaml.saml.metadata.generator.impl.ArtifactResolutionServiceConverter;
import org.opensaml.saml.metadata.generator.impl.SingleLogoutServiceConverter;
import org.opensaml.saml.metadata.generator.impl.SingleSignOnServiceConverter;
import org.opensaml.saml.metadata.generator.impl.TemplateMetadataGeneratorParameters;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;

public class InstalledMetadataParameters
extends AbstractInitializableComponent
implements TemplateMetadataGeneratorParameters {
    private final Logger log = LoggerFactory.getLogger(InstalledMetadataParameters.class);
    @Nullable
    private File encryptionCert;
    @Nullable
    private File backChannelCert;
    @Nullable
    private File signingCert;
    @NonnullAfterInit
    private String entityID;
    @NonnullAfterInit
    private String dnsName;
    @Nullable
    private String scope;
    @NonnullAfterInit
    private String contextPath = "/idp";
    @Nonnull
    private List<Pair<String, String>> logoutServices;
    @Nonnull
    private List<Pair<String, String>> ssoServices;
    @Nonnull
    private final List<Pair<String, String>> artifactServices = CollectionSupport.emptyList();

    private void setupSevices() {
        this.logoutServices = CollectionSupport.listOf((Object)new Pair((Object)"Redirect/", (Object)(this.contextPath + "/profile/SAML2/SOAP/Redirect/SLO")), (Object)new Pair((Object)"POST/", (Object)(this.contextPath + "/profile/SAML2/POST/SLO")));
        this.ssoServices = CollectionSupport.listOf((Object[])new Pair[]{new Pair((Object)"SimpleSign/", (Object)(this.contextPath + "/profile/SAML2/POST-SimpleSign/SSO")), new Pair((Object)"Redirect/", (Object)(this.contextPath + "/profile/SAML2/Redirect/SSO")), new Pair((Object)"POST/", (Object)(this.contextPath + "/profile/SAML2/POST/SSO"))});
    }

    public void setContextPath(@Nonnull String what) {
        this.contextPath = what;
        if (this.isInitialized()) {
            this.setupSevices();
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.entityID == null || this.entityID.isEmpty()) {
            throw new ComponentInitializationException("Entity ID not specified");
        }
        if (this.dnsName == null || this.dnsName.isEmpty()) {
            throw new ComponentInitializationException("DNS name not specified");
        }
        this.setupSevices();
    }

    public void setEncryptionCertResource(@Nonnull Resource resource) {
        try {
            this.encryptionCert = resource.getFile();
        }
        catch (IOException e) {
            this.log.error("Could not open encryption  cert", (Throwable)e);
            this.encryptionCert = null;
        }
    }

    public void setSigningCertResource(@Nonnull Resource resource) {
        try {
            this.signingCert = resource.getFile();
        }
        catch (IOException e) {
            this.log.error("Could not open signing cert", (Throwable)e);
            this.signingCert = null;
        }
    }

    public void setBackchannelCertResource(@Nonnull Resource resource) {
        try {
            this.backChannelCert = resource.getFile();
        }
        catch (IOException e) {
            this.log.error("Could not open back channel cert", (Throwable)e);
            this.backChannelCert = null;
        }
    }

    @Nullable
    private String getEncodedCertificate(@Nullable File file) {
        if (file == null) {
            return null;
        }
        try {
            byte[] cert = X509Support.decodeCertificate((File)file).getEncoded();
            assert (cert != null);
            return Base64Support.encode((byte[])cert, (boolean)true);
        }
        catch (CertificateException | EncodingException e) {
            this.log.warn("Unable to decode and re-encode certificate at path {}", (Object)file, (Object)e);
            return null;
        }
    }

    public void setEntityID(@Nonnull String id) {
        this.entityID = id;
    }

    public void setDnsName(@Nonnull String name) {
        this.dnsName = name;
    }

    public void setScope(@Nullable String value) {
        this.scope = value;
    }

    @Nullable
    public String getEntityID() {
        return this.entityID;
    }

    @Nullable
    public Set<Namespace> getAdditionalNamespaces() {
        HashSet<Namespace> namespaces = new HashSet<Namespace>();
        namespaces.add(new Namespace("urn:oasis:names:tc:SAML:metadata:ui", "mdui"));
        if (this.scope != null) {
            namespaces.add(new Namespace("urn:mace:shibboleth:metadata:1.0", "shibmd"));
        }
        return namespaces;
    }

    @Nonnull
    private <T extends Endpoint> Collection<T> convertEndpoints(@Nonnull BiFunction<String, List<String>, T> converter, @Nonnull @Live List<String> protocols, @Nonnull Collection<Pair<String, String>> input) {
        return (Collection)((NonnullSupplier)input.stream().map(p -> (Endpoint)converter.apply(new StringBuffer((String)p.getFirst()).append(this.dnsName).append((String)p.getSecond()).toString(), protocols)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    @Nullable
    public IDPSSODescriptor getIDPSSODescriptor() {
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder idpSSOBuilder = (SAMLObjectBuilder)bf.ensureBuilder(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        IDPSSODescriptor role = (IDPSSODescriptor)idpSSOBuilder.buildObject();
        ArrayList<String> protocols = new ArrayList<String>();
        role.getSingleLogoutServices().addAll(this.convertEndpoints((BiFunction)new SingleLogoutServiceConverter(), (List<String>)protocols, (Collection<Pair<String, String>>)this.logoutServices));
        role.getSingleSignOnServices().addAll(this.convertEndpoints((BiFunction)new SingleSignOnServiceConverter(), (List<String>)protocols, (Collection<Pair<String, String>>)this.ssoServices));
        role.getArtifactResolutionServices().addAll(this.convertEndpoints((BiFunction)new ArtifactResolutionServiceConverter(), (List<String>)protocols, (Collection<Pair<String, String>>)this.artifactServices));
        int index = 1;
        for (IndexedEndpoint e : role.getArtifactResolutionServices()) {
            e.setIndex(Integer.valueOf(index++));
        }
        protocols.forEach(arg_0 -> ((IDPSSODescriptor)role).addSupportedProtocol(arg_0));
        return role;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getSigningCertificates() {
        ArrayList<String> result = new ArrayList<String>(2);
        String cert = this.getEncodedCertificate(this.backChannelCert);
        if (cert != null) {
            result.add(cert);
        }
        if ((cert = this.getEncodedCertificate(this.signingCert)) != null) {
            result.add(cert);
        }
        return result;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getEncryptionCertificates() {
        String cert = this.getEncodedCertificate(this.encryptionCert);
        if (cert == null) {
            return CollectionSupport.emptyList();
        }
        return CollectionSupport.singletonList((Object)cert);
    }

    @Nullable
    public String getLang() {
        return "en";
    }

    @Nullable
    public String getDisplayName() {
        return new StringBuffer("A name for the IdP at ").append(this.dnsName).toString();
    }

    @Nullable
    public String getDescription() {
        return new StringBuffer("Enter a description for the IdP at ").append(this.dnsName).toString();
    }

    @Nullable
    public Logo getLogo() {
        Logo result = new LogoBuilder().buildObject();
        result.setHeight(Integer.valueOf(80));
        result.setWidth(Integer.valueOf(80));
        result.setURI(new StringBuffer("https://").append(this.dnsName).append("/path/to/logo.png").toString());
        return result;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getScopes() {
        String s = this.scope;
        if (s == null) {
            return CollectionSupport.emptyList();
        }
        return CollectionSupport.singletonList((Object)s);
    }
}

