/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public final class PropertiesWithComments {
    private List<Object> contents;
    private Map<String, CommentedProperty> properties;
    @Nonnull
    private final Properties nameReplacement = new Properties();
    @Nonnull
    private final Set<String> unreplacableNames;
    private boolean loadedData;

    public PropertiesWithComments() {
        this(CollectionSupport.emptySet());
    }

    public PropertiesWithComments(@Nonnull Set<String> unreplacable) {
        this.unreplacableNames = CollectionSupport.copyToSet(unreplacable);
    }

    private void addCommentedProperty(@Nonnull @NotEmpty String line, boolean isComment) throws IOException {
        Properties parser = new Properties();
        String modifiedLine = isComment ? line.substring(1) : line;
        parser.load(new ByteArrayInputStream(modifiedLine.getBytes()));
        if (!parser.isEmpty()) {
            String propName = StringSupport.trimOrNull((String)parser.stringPropertyNames().iterator().next());
            if (propName != null) {
                String outputLine = line;
                String value = parser.getProperty(propName);
                String newPropName = StringSupport.trimOrNull((String)this.nameReplacement.getProperty(propName));
                if (newPropName != null && !newPropName.isEmpty()) {
                    if (isComment) {
                        if (newPropName.contains(propName)) {
                            outputLine = outputLine.replace(propName, newPropName);
                        } else {
                            while (outputLine.contains(propName)) {
                                outputLine = outputLine.replace(propName, newPropName);
                            }
                        }
                    }
                    propName = newPropName;
                }
                CommentedProperty commentedProperty = isComment ? new CommentedProperty(propName, outputLine, true) : new CommentedProperty(propName, value, false);
                this.properties.put(propName, commentedProperty);
                this.contents.add(commentedProperty);
            }
        } else {
            this.contents.add(line);
        }
        parser.clear();
    }

    public void loadNameReplacement(InputStream input) throws IOException {
        if (this.loadedData) {
            throw new IOException("Cannot load name replacement after the data");
        }
        this.nameReplacement.load(input);
    }

    public void load(InputStream input) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            this.contents = new ArrayList<Object>();
            this.properties = new HashMap<String, CommentedProperty>();
            String s = reader.readLine();
            while (s != null) {
                String what = StringSupport.trimOrNull((String)s);
                if (what == null) {
                    this.contents.add("");
                } else if (what.startsWith("#")) {
                    if (what.contains("=")) {
                        this.addCommentedProperty(s, true);
                    } else {
                        this.contents.add(s);
                    }
                } else if (what.startsWith("--") || !what.contains("=")) {
                    this.contents.add(s);
                } else {
                    this.addCommentedProperty(s, false);
                }
                s = reader.readLine();
            }
            this.loadedData = true;
        }
    }

    public void store(OutputStream output) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));){
            for (Object o : this.contents) {
                if (o instanceof String) {
                    writer.write((String)o);
                } else if (o instanceof CommentedProperty) {
                    CommentedProperty commentedProperty = (CommentedProperty)o;
                    commentedProperty.write(writer);
                }
                writer.newLine();
            }
            writer.flush();
        }
    }

    public void replaceProperties(Properties replacements) {
        for (Object propName : replacements.keySet()) {
            if (!(propName instanceof String)) continue;
            String name = (String)propName;
            this.replaceProperty(name, replacements.getProperty(name));
        }
    }

    public boolean replaceProperty(String propName, String newPropValue) {
        Constraint.isFalse((boolean)this.unreplacableNames.contains(propName), (String)("property '" + propName + "' cannot be replaced"));
        CommentedProperty p = this.properties.get(propName);
        if (null != p) {
            p.setValue(newPropValue);
            return true;
        }
        p = new CommentedProperty(propName, newPropValue, false);
        this.contents.add(p);
        this.properties.put(propName, p);
        return false;
    }

    public void addComment(String what) {
        this.contents.add("# " + what);
    }

    private static class CommentedProperty {
        private final String property;
        private String value;
        private boolean isComment;

        CommentedProperty(String prop, String val, boolean comment) {
            this.property = prop;
            this.value = val;
            this.isComment = comment;
        }

        protected void setValue(String newValue) {
            this.value = newValue;
            this.isComment = false;
        }

        protected void write(BufferedWriter writer) throws IOException {
            if (this.isComment) {
                writer.write(this.value);
            } else {
                writer.write(this.property);
                writer.write("=");
                writer.write(this.value);
            }
        }
    }
}

