/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public final class AttributeRule
extends AbstractIdentifiableInitializableComponent
implements UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRule.class);
    @Nullable
    private String logPrefix;
    @NonnullAfterInit
    private String attributeId;
    @NonnullAfterInit
    private Matcher matcher;
    private boolean isDenyRule = true;

    @NonnullAfterInit
    public String getAttributeId() {
        this.ifDestroyedThrowDestroyedComponentException();
        return this.attributeId;
    }

    public void setAttributeId(@Nonnull @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.attributeId = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    public Matcher getMatcher() {
        this.ifDestroyedThrowDestroyedComponentException();
        return this.matcher;
    }

    public void setMatcher(@Nonnull Matcher theMatcher) {
        this.checkSetterPreconditions();
        this.matcher = (Matcher)Constraint.isNotNull((Object)theMatcher, (String)"Rule can not be null");
    }

    public boolean getIsDenyRule() {
        this.ifDestroyedThrowDestroyedComponentException();
        return this.isDenyRule;
    }

    public void setIsDenyRule(boolean isDeny) {
        this.checkSetterPreconditions();
        this.isDenyRule = isDeny;
    }

    public void apply(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) throws AttributeFilterException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)attribute, (String)"To-be-filtered attribute can not be null");
        Constraint.isNotNull((Object)((Object)filterContext), (String)"Attribute filter context can not be null");
        AttributeFilterWorkContext filterWorkContext = (AttributeFilterWorkContext)((Object)Constraint.isNotNull((Object)((Object)((AttributeFilterWorkContext)filterContext.getSubcontext(AttributeFilterWorkContext.class))), (String)"Attribute filter work context can not be null"));
        this.log.debug("{} Filtering values for attribute '{}' which currently contains {} values", new Object[]{this.getLogPrefix(), this.getAttributeId(), attribute.getValues().size()});
        Set<IdPAttributeValue> matchingValues = this.matcher.getMatchingValues(attribute, filterContext);
        if (!this.isDenyRule) {
            if (null == matchingValues) {
                this.log.warn("{} Filter failed. No values released for attribute '{}'", (Object)this.getLogPrefix(), (Object)this.getAttributeId());
            } else {
                this.log.debug("{} Filter has permitted the release of {} values for attribute '{}'", new Object[]{this.getLogPrefix(), matchingValues.size(), attribute.getId()});
                filterWorkContext.addPermittedIdPAttributeValues(attribute.getId(), matchingValues);
            }
        } else if (null == matchingValues) {
            this.log.warn("{} Filter failed. All values denied for attribute '{}'", (Object)this.getLogPrefix(), (Object)this.getAttributeId());
            filterWorkContext.addDeniedIdPAttributeValues(attribute.getId(), attribute.getValues());
        } else {
            this.log.debug("{} Filter has denied the release of {} values for attribute '{}'", new Object[]{this.getLogPrefix(), matchingValues.size(), attribute.getId()});
            filterWorkContext.addDeniedIdPAttributeValues(attribute.getId(), matchingValues);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
        if (null == this.getAttributeId()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No attribute specified for this attribute value filter policy");
        }
        if (this.matcher == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " Must have a permit rule or a deny rule");
        }
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String result = this.logPrefix;
        if (null == result) {
            this.logPrefix = result = new StringBuffer("Attribute filtering engine '").append(this.getId()).append("' ").toString();
        }
        assert (result != null);
        return result;
    }
}

