/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.nameid.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.saml2.nameid.transcoding.AbstractSAML2NameIDTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;

public class SAML2ScopedStringNameIDTranscoder
extends AbstractSAML2NameIDTranscoder<ScopedStringAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_TEMPLATE = "saml2.valueTemplate";
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_DELIMITER = "saml2.scopeDelimiter";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE = "$Name";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_DELIMITER = "@";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2ScopedStringNameIDTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof ScopedStringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull ScopedStringAttributeValue value) throws AttributeEncodingException {
        throw new AttributeEncodingException("NameID transcoders do not support encoding");
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull NameID nameID, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        int offset;
        String scopeDelimiter;
        String scope = null;
        String stringValue = nameID.getValue();
        if (stringValue != null) {
            scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)DEFAULT_DELIMITER);
            assert (scopeDelimiter != null);
            offset = stringValue.indexOf(scopeDelimiter);
            if (offset < 0) {
                this.log.warn("Ignoring value with no scope delimiter ({})", (Object)scopeDelimiter);
                return null;
            }
        } else {
            this.log.warn("Ignoring empty value since scope is subsequently null");
            return null;
        }
        scope = stringValue.substring(offset + scopeDelimiter.length());
        stringValue = stringValue.substring(0, offset);
        StringBuilder builder = new StringBuilder((String)rule.getOrDefault(PROP_TEMPLATE, String.class, (Object)DEFAULT_TEMPLATE));
        Boolean flag = (Boolean)rule.getOrDefault("saml2.defaultQualifiers", Boolean.class, (Object)false);
        assert (flag != null);
        int i = builder.indexOf("$Format");
        if (i >= 0) {
            String format = nameID.getFormat();
            builder.replace(i, i + 7, format != null ? format : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        if ((i = builder.indexOf("$SPNameQualifier")) >= 0) {
            builder.replace(i, i + 16, this.getSPNameQualifier(profileRequestContext, nameID, flag));
        }
        if ((i = builder.indexOf("$NameQualifier")) >= 0) {
            builder.replace(i, i + 14, this.getNameQualifier(profileRequestContext, nameID, flag));
        }
        if ((i = builder.indexOf(DEFAULT_TEMPLATE)) >= 0) {
            builder.replace(i, i + 5, stringValue != null ? stringValue : "");
        }
        return new ScopedStringAttributeValue(builder.toString(), scope);
    }
}

