/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2StringAttributeTranscoder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;

@NotThreadSafe
public class AttributeMappingNodeProcessor
implements MetadataNodeProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeMappingNodeProcessor.class);
    @Nonnull
    private final ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private final AttributeTranscoder<Attribute> defaultTranscoder;

    public AttributeMappingNodeProcessor(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
        this.defaultTranscoder = new SAML2StringAttributeTranscoder();
        try {
            this.defaultTranscoder.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Error initializing default transcoder");
        }
    }

    public void process(@Nonnull XMLObject metadataNode) throws FilterException {
        if (metadataNode instanceof AttributeConsumingService || metadataNode instanceof EntityDescriptor) {
            try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
                if (metadataNode instanceof AttributeConsumingService) {
                    this.handleAttributeConsumingService((AttributeTranscoderRegistry)component.getComponent(), (AttributeConsumingService)metadataNode);
                } else if (metadataNode instanceof EntityDescriptor) {
                    this.handleEntityAttributes((AttributeTranscoderRegistry)component.getComponent(), ((EntityDescriptor)metadataNode).getExtensions());
                    XMLObject parent = metadataNode.getParent();
                    while (parent instanceof EntitiesDescriptor) {
                        this.handleEntityAttributes((AttributeTranscoderRegistry)component.getComponent(), ((EntitiesDescriptor)parent).getExtensions());
                        parent = parent.getParent();
                    }
                }
            }
            catch (ServiceException e) {
                this.log.warn("Invalid AttributeTranscoderRegistry configuration", (Throwable)e);
            }
        }
    }

    private void handleAttributeConsumingService(@Nonnull AttributeTranscoderRegistry registry, @Nonnull AttributeConsumingService acs) {
        List requestedAttributes = acs.getRequestedAttributes();
        if (null == requestedAttributes || requestedAttributes.isEmpty()) {
            return;
        }
        HashMultimap results = HashMultimap.create();
        assert (results != null);
        for (RequestedAttribute req : requestedAttributes) {
            try {
                assert (req != null);
                this.decodeAttribute(registry.getTranscodingRules((Object)req), req, (Multimap<String, IdPAttribute>)results);
            }
            catch (AttributeDecodingException e) {
                this.log.warn("Error decoding RequestedAttribute '{}'", (Object)req.getName(), (Object)e);
            }
        }
        if (!results.isEmpty()) {
            acs.getObjectMetadata().put((Object)new AttributesMapContainer((Multimap)results));
        }
    }

    private void handleEntityAttributes(@Nonnull AttributeTranscoderRegistry registry, @Nullable Extensions extensions) {
        if (null == extensions) {
            return;
        }
        List entityAttributesList = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        if (null == entityAttributesList || entityAttributesList.isEmpty()) {
            return;
        }
        XMLObject parent = extensions.getParent();
        if (parent == null) {
            this.log.warn("Extensions object had no parent to store results");
            return;
        }
        HashMultimap results = HashMultimap.create();
        assert (results != null);
        for (XMLObject xmlObj : entityAttributesList) {
            if (!(xmlObj instanceof EntityAttributes)) continue;
            EntityAttributes ea = (EntityAttributes)xmlObj;
            for (Attribute attr : ea.getAttributes()) {
                try {
                    assert (attr != null);
                    Collection rulesets = registry.getTranscodingRules((Object)attr);
                    if (rulesets.isEmpty() && "urn:oasis:names:tc:SAML:2.0:attrname-format:uri".equals(attr.getNameFormat())) {
                        this.log.trace("Applying default decoding rule for URI-named attribute {}", (Object)attr.getName());
                        HashMap<String, String> rulemap = new HashMap<String, String>();
                        rulemap.put("id", attr.getName());
                        rulemap.put("transcoder", (String)this.defaultTranscoder);
                        rulemap.put("saml2.name", attr.getName());
                        TranscodingRule defaultRule = new TranscodingRule(rulemap);
                        rulesets = CollectionSupport.singletonList((Object)defaultRule);
                    }
                    assert (rulesets != null);
                    this.decodeAttribute(rulesets, attr, (Multimap<String, IdPAttribute>)results);
                }
                catch (AttributeDecodingException e) {
                    this.log.warn("Error decoding RequestedAttribute '{}'", (Object)attr.getName(), (Object)e);
                }
            }
        }
        if (!results.isEmpty()) {
            parent.getObjectMetadata().put((Object)new AttributesMapContainer((Multimap)results));
        }
    }

    private <T> void decodeAttribute(@Nonnull Collection<TranscodingRule> rules, @Nonnull T input, @Nonnull Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        for (TranscodingRule rule : rules) {
            assert (rule != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            IdPAttribute decodedAttribute = transcoder.decode(null, input, rule);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }
}

