/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAMLAttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAML1AttributeTranscoder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.slf4j.Logger;

public abstract class AbstractSAML1AttributeTranscoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeTranscoder<AttributeDesignator, EncodedType>
implements SAML1AttributeTranscoder<EncodedType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAML1AttributeTranscoder.class);
    @Nonnull
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Attribute.TYPE_NAME);
    @Nonnull
    private final SAMLObjectBuilder<AttributeDesignator> designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AttributeDesignator.TYPE_NAME);

    @Nonnull
    public Class<AttributeDesignator> getEncodedType() {
        return AttributeDesignator.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        try {
            return new NamingFunction().apply(this.buildAttribute((ProfileRequestContext)null, (IdPAttribute)null, (Class<? extends AttributeDesignator>)AttributeDesignator.class, rule, (List<XMLObject>)CollectionSupport.emptyList()));
        }
        catch (AttributeEncodingException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    protected AttributeDesignator buildAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull Class<? extends AttributeDesignator> to, @Nonnull TranscodingRule rule, @Nonnull List<XMLObject> attributeValues) throws AttributeEncodingException {
        AttributeDesignator samlAttribute;
        if (attribute != null && !attribute.getValues().isEmpty() && attributeValues.isEmpty()) {
            throw new AttributeEncodingException("Failed to encode any values for attribute " + attribute.getId());
        }
        if (to.equals(Attribute.class)) {
            if (attributeValues.isEmpty()) {
                throw new AttributeEncodingException("Unable to encode a SAML 1 Attribute with no values");
            }
            samlAttribute = (AttributeDesignator)this.attributeBuilder.buildObject();
            ((Attribute)samlAttribute).getAttributeValues().addAll(attributeValues);
        } else if (to.equals(AttributeDesignator.class)) {
            samlAttribute = (AttributeDesignator)this.designatorBuilder.buildObject();
            if (!attributeValues.isEmpty()) {
                this.log.warn("Lossy conversion to AttributeDesignator");
            }
        } else {
            throw new AttributeEncodingException("Unsupported target object type: " + to.getName());
        }
        this.encodeName(profileRequestContext, attribute, samlAttribute, rule);
        return samlAttribute;
    }

    protected void encodeName(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull AttributeDesignator samlAttribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String name;
        Boolean useMetadata = (Boolean)rule.getOrDefault("saml1.nameFromMetadata", Boolean.class, (Object)false);
        if (useMetadata != null && useMetadata.booleanValue()) {
            String id;
            String string = id = attribute != null ? attribute.getId() : (String)rule.get("id", String.class);
            if (id == null) {
                this.log.warn("Rule specified {} but no attribute ID available", (Object)"saml1.nameFromMetadata");
            } else {
                String tagValue = this.getNameFromMetadata(profileRequestContext, id);
                if (tagValue != null) {
                    int lastSpace = tagValue.lastIndexOf(32);
                    if (lastSpace > 0) {
                        String name2 = StringSupport.trimOrNull((String)tagValue.substring(0, lastSpace));
                        String namespace = StringSupport.trimOrNull((String)tagValue.substring(lastSpace));
                        if (name2 != null && namespace != null) {
                            samlAttribute.setAttributeName(name2);
                            samlAttribute.setAttributeNamespace(namespace);
                            this.log.debug("Encoding IdPAttribute {} via metadata tag as Name {}, Namespace {}", new Object[]{id, name2, namespace});
                            return;
                        }
                    }
                    this.log.warn("Metadata tag {}, value {}, was not in the expected form", (Object)"http://shibboleth.net/ns/attributes/naming/saml1", (Object)tagValue);
                }
            }
        }
        if (Strings.isNullOrEmpty((String)(name = (String)rule.get("saml1.name", String.class)))) {
            throw new AttributeEncodingException("Required transcoder property 'saml1.name' not found");
        }
        samlAttribute.setAttributeName(name);
        samlAttribute.setAttributeNamespace((String)rule.getOrDefault("saml1.namespace", String.class, (Object)"urn:mace:shibboleth:1.0:attributeNamespace:uri"));
    }

    @Override
    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull AttributeDesignator attribute, @Nonnull TranscodingRule rule, @Nonnull List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        IdPRequestedAttribute idpAttribute;
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        assert (id != null);
        if (attribute instanceof Attribute) {
            if (!((Attribute)attribute).getAttributeValues().isEmpty() && attributeValues.isEmpty()) {
                throw new AttributeDecodingException("Failed to decode any values for attribute " + attribute.getAttributeName());
            }
            idpAttribute = new IdPAttribute(id);
        } else {
            idpAttribute = new IdPRequestedAttribute(id);
        }
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Override
    @Nonnull
    protected Iterable<XMLObject> getValues(@Nonnull AttributeDesignator input) {
        return input instanceof Attribute ? ((Attribute)input).getAttributeValues() : CollectionSupport.emptyList();
    }

    public static class NamingFunction
    implements Function<AttributeDesignator, String> {
        @Override
        @Nullable
        public String apply(@Nullable AttributeDesignator input) {
            if (input == null || input.getAttributeName() == null || input.getAttributeNamespace() == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SAML1:{").append(input.getAttributeNamespace()).append('}').append(input.getAttributeName());
            return builder.toString();
        }
    }
}

