/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;

public class CredentialConfigFactoryBean
extends AbstractComponentAwareFactoryBean<CredentialConfig> {
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(CredentialConfigFactoryBean.class);
    @Nullable
    private Credential trustCredential;
    @Nullable
    private Credential authCredential;

    @Nonnull
    public Class<?> getObjectType() {
        return CredentialConfig.class;
    }

    @Nonnull
    protected CredentialConfig doCreateInstance() throws Exception {
        X509Certificate[] trustCerts = null;
        if (this.trustCredential != null) {
            if (this.trustCredential instanceof X509Credential) {
                X509Credential cred = (X509Credential)this.trustCredential;
                trustCerts = cred.getEntityCertificateChain().toArray(new X509Certificate[cred.getEntityCertificateChain().size()]);
            } else {
                assert (this.trustCredential != null);
                log.error("Supplied StartTLSTrustCredential was of type {}, not {}", (Object)this.trustCredential.getClass().getName(), (Object)X509Credential.class.getName());
                throw new BeanCreationException("Supplied StartTLSTrustCredential was of wrong type");
            }
        }
        X509Certificate authCert = null;
        PrivateKey authKey = null;
        if (this.authCredential != null) {
            if (this.authCredential instanceof X509Credential) {
                X509Credential cred = (X509Credential)this.authCredential;
                authCert = cred.getEntityCertificate();
                authKey = cred.getPrivateKey();
            } else {
                assert (this.authCredential != null);
                log.error("Supplied StartTLSAuthenticationCredential was of type {}, not {}", (Object)this.authCredential.getClass().getName(), (Object)X509Credential.class.getName());
                throw new BeanCreationException("Supplied StartTLSAuthenticationCredential was of wrong type");
            }
        }
        CredentialConfig result = CredentialConfigFactory.createX509CredentialConfig(trustCerts, authCert, authKey);
        assert (result != null);
        return result;
    }

    @Nullable
    public Credential getAuthCredential() {
        return this.authCredential;
    }

    public void setAuthCredential(@Nullable Credential credential) {
        this.authCredential = credential;
    }

    @Nullable
    public Credential getTrustCredential() {
        return this.trustCredential;
    }

    public void setTrustCredential(@Nullable Credential credential) {
        this.trustCredential = credential;
    }
}

