/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValue;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SourceValueParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SourceValue");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SourceValueParser.class);

    @Nullable
    protected Class<SourceValue> getBeanClass(@Nullable Element element) {
        return SourceValue.class;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        String value = config.getTextContent();
        builder.addPropertyValue("value", (Object)value);
        String caseSensitive = null;
        if (config.hasAttributeNS(null, "caseSensitive")) {
            caseSensitive = StringSupport.trimOrNull((String)config.getAttributeNS(null, "caseSensitive"));
            builder.addPropertyValue("caseSensitive", (Object)SpringSupport.getStringValueAsBoolean((String)caseSensitive));
        }
        String partialMatch = null;
        if (config.hasAttributeNS(null, "partialMatch")) {
            partialMatch = StringSupport.trimOrNull((String)config.getAttributeNS(null, "partialMatch"));
            builder.addPropertyValue("partialMatch", (Object)SpringSupport.getStringValueAsBoolean((String)partialMatch));
        }
        this.log.debug("SourceValue value: {}, caseSensitive: {}, partialMatch: {}", new Object[]{value, caseSensitive, partialMatch});
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

