/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.logic.ResolutionLabelPredicate;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputDataConnectorParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseResolverPluginParser
extends AbstractCustomBeanDefinitionParser {
    @Nullable
    private Class<? extends Predicate<?>> relyingPartyPredicateClass;
    @Nullable
    private String relyingPartyPredicateFactoryMethod;
    @Nonnull
    @NotEmpty
    private String defnId = "<Unnamed Attribute or Connector>";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseResolverPluginParser.class);

    public BaseResolverPluginParser() {
        try {
            String className = BaseResolverPluginParser.getCustomProperty((String)(BaseResolverPluginParser.class.getName() + ".RelyingPartyIdPredicate.class"), null);
            if (className != null) {
                this.relyingPartyPredicateClass = Class.forName(className);
                this.log.trace("Using class for mapped tag predicate: {}", (Object)className);
                this.relyingPartyPredicateFactoryMethod = BaseResolverPluginParser.getCustomProperty((String)(BaseResolverPluginParser.class.getName() + ".RelyingPartyIdPredicate.factoryMethod"), null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nonnull
    @NotEmpty
    protected String getDefinitionId() {
        return this.defnId;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String id = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        this.log.debug("Parsing configuration for {} plugin with id: {}", (Object)config.getLocalName(), (Object)id);
        builder.addPropertyValue("id", (Object)id);
        if (null != id) {
            this.defnId = id;
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            if (config.hasAttributeNS(null, "relyingParties") || config.hasAttributeNS(null, "resolutionPhases") || config.hasAttributeNS(null, "excludeRelyingParties") || config.hasAttributeNS(null, "excludeResolutionPhases")) {
                this.log.warn("relyingParties/resolutionPhases and variants ignored, using activationConditionRef");
            }
            builder.addPropertyReference("activationCondition", AttributeSupport.ensureAttributeValue((Element)config, null, (String)"activationConditionRef"));
        } else {
            BeanDefinitionBuilder condition = this.getActivationCondition(config);
            if (condition != null) {
                builder.addPropertyValue("activationCondition", (Object)condition.getBeanDefinition());
            }
        }
        if (config.hasAttributeNS(null, "propagateResolutionExceptions")) {
            builder.addPropertyValue("propagateResolutionExceptions", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "propagateResolutionExceptions")));
        }
        List attributeDependencyElements = ElementSupport.getChildElements((Node)config, (QName)InputAttributeDefinitionParser.ELEMENT_NAME);
        List dataConnectorDependencyElements = ElementSupport.getChildElements((Node)config, (QName)InputDataConnectorParser.ELEMENT_NAME);
        if (null != attributeDependencyElements && !attributeDependencyElements.isEmpty() || null != dataConnectorDependencyElements && !dataConnectorDependencyElements.isEmpty()) {
            if (this.failOnDependencies()) {
                this.log.error("{} Dependencies are not allowed.", (Object)this.getLogPrefix());
                throw new BeanCreationException(this.getLogPrefix() + " has meaningless Dependencies statements");
            }
            if (this.warnOnDependencies()) {
                this.log.warn("{} Dependencies are not allowed.", (Object)this.getLogPrefix());
            }
        }
        builder.addPropertyValue("attributeDependencies", (Object)SpringSupport.parseCustomElements((Collection)attributeDependencyElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        builder.addPropertyValue("dataConnectorDependencies", (Object)SpringSupport.parseCustomElements((Collection)dataConnectorDependencyElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
    }

    @Nullable
    protected BeanDefinitionBuilder getActivationCondition(@Nonnull Element config) {
        BeanDefinitionBuilder rpBuilder = null;
        BeanDefinitionBuilder phasesBuilder = null;
        Attr relyingPartiesAttr = config.getAttributeNodeNS(null, "relyingParties");
        Attr excludeRelyingPartiesAttr = config.getAttributeNodeNS(null, "excludeRelyingParties");
        if (relyingPartiesAttr != null) {
            if (this.relyingPartyPredicateClass == null) {
                this.log.warn("Ignoring relyingParties setting due to class instantiation failure at startup");
                return null;
            }
            if (excludeRelyingPartiesAttr != null) {
                this.log.warn("excludeRelyingParties ignored, using relyingParties");
            }
            assert (this.relyingPartyPredicateClass != null);
            rpBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.relyingPartyPredicateClass);
            if (this.relyingPartyPredicateFactoryMethod != null) {
                rpBuilder.setFactoryMethod(this.relyingPartyPredicateFactoryMethod);
            }
            rpBuilder.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)relyingPartiesAttr));
        } else if (excludeRelyingPartiesAttr != null) {
            if (this.relyingPartyPredicateClass == null) {
                this.log.warn("Ignoring excludeRelyingParties setting due to class instantiation failure at startup");
                return null;
            }
            assert (this.relyingPartyPredicateClass != null);
            BeanDefinitionBuilder unnegated = BeanDefinitionBuilder.genericBeanDefinition(this.relyingPartyPredicateClass);
            if (this.relyingPartyPredicateFactoryMethod != null) {
                unnegated.setFactoryMethod(this.relyingPartyPredicateFactoryMethod);
            }
            unnegated.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)excludeRelyingPartiesAttr));
            rpBuilder = BeanDefinitionBuilder.genericBeanDefinition(PredicateSupport.class);
            rpBuilder.setFactoryMethod("not");
            rpBuilder.addConstructorArgValue((Object)unnegated.getBeanDefinition());
        }
        Attr resolutionPhasesAttr = config.getAttributeNodeNS(null, "resolutionPhases");
        Attr excludeResolutionPhasesAttr = config.getAttributeNodeNS(null, "excludeResolutionPhases");
        if (resolutionPhasesAttr != null) {
            if (excludeResolutionPhasesAttr != null) {
                this.log.warn("excludeResolutionPhases ignored, using resolutionPhases");
            }
            phasesBuilder = BeanDefinitionBuilder.genericBeanDefinition(ResolutionLabelPredicate.class);
            phasesBuilder.setFactoryMethod("byList");
            phasesBuilder.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)resolutionPhasesAttr));
        } else if (excludeResolutionPhasesAttr != null) {
            BeanDefinitionBuilder unnegated = BeanDefinitionBuilder.genericBeanDefinition(ResolutionLabelPredicate.class);
            unnegated.setFactoryMethod("byList");
            unnegated.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)excludeResolutionPhasesAttr));
            phasesBuilder = BeanDefinitionBuilder.genericBeanDefinition(PredicateSupport.class);
            phasesBuilder.setFactoryMethod("not");
            phasesBuilder.addConstructorArgValue((Object)unnegated.getBeanDefinition());
        }
        if (rpBuilder != null && phasesBuilder != null) {
            BeanDefinitionBuilder andBuilder = BeanDefinitionBuilder.genericBeanDefinition(PredicateSupport.class);
            andBuilder.setFactoryMethod("and");
            andBuilder.addConstructorArgValue((Object)rpBuilder.getBeanDefinition());
            andBuilder.addConstructorArgValue((Object)phasesBuilder.getBeanDefinition());
            return andBuilder;
        }
        if (rpBuilder != null) {
            return rpBuilder;
        }
        if (phasesBuilder != null) {
            return phasesBuilder;
        }
        return null;
    }

    protected boolean failOnDependencies() {
        return false;
    }

    protected boolean warnOnDependencies() {
        return false;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Unknown Plugin '").append(this.getDefinitionId()).append("':");
        String result = builder.toString();
        assert (result != null);
        return result;
    }
}

