/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.spring;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DeprecatedPropertyBean
extends AbstractInitializableComponent
implements ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger((String)"DEPRECATED");
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private Map<String, String> deprecatedProperties = CollectionSupport.emptyMap();
    @Nonnull
    private Collection<String> deadProperties = CollectionSupport.emptyList();

    public void setDeprecatedProperties(@Nonnull Map<String, String> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"Property map cannot be null");
        this.deprecatedProperties = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.deprecatedProperties.put(StringSupport.trimOrNull((String)entry.getKey()), StringSupport.trimOrNull((String)entry.getValue()));
        }
    }

    public void setDeadProperties(@Nonnull Collection<String> properties) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(properties, (String)"Property collection cannot be null");
        this.deadProperties = StringSupport.normalizeStringCollection(properties);
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) {
        this.applicationContext = (ApplicationContext)Constraint.isNotNull((Object)context, (String)"ApplicationContext cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        ApplicationContext context = this.applicationContext;
        if (context == null) {
            throw new ComponentInitializationException("ApplicationContext cannot be null");
        }
        for (Map.Entry<String, String> entry : this.deprecatedProperties.entrySet()) {
            String key = entry.getKey();
            assert (key != null);
            if (!context.getEnvironment().containsProperty(key)) continue;
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)key, null, (String)entry.getValue());
        }
        for (String name : this.deadProperties) {
            assert (name != null);
            if (!context.getEnvironment().containsProperty(name)) continue;
            this.log.warn("property '{}' is no longer supported", (Object)name);
        }
    }
}

