/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AttributeSourcedAuthnContextTranslationStrategy
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, Collection<Principal>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedAuthnContextTranslationStrategy.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Set<String> attributeSourceIDs = CollectionSupport.emptySet();
    @Nonnull
    private Map<String, String> valueMappings = CollectionSupport.emptyMap();

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeSourceIDs(@Nonnull Collection<String> sources) {
        this.checkSetterPreconditions();
        this.attributeSourceIDs = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(sources));
    }

    public void setValueMappings(@Nullable Map<String, String> mappings) {
        this.checkSetterPreconditions();
        if (mappings != null) {
            this.valueMappings = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                if (entry.getKey() == null) continue;
                this.valueMappings.put(entry.getKey(), StringSupport.trimOrNull((String)entry.getValue()));
            }
        } else {
            this.valueMappings = CollectionSupport.emptyMap();
        }
    }

    @Override
    @Nullable
    public Collection<Principal> apply(@Nullable ProfileRequestContext input) {
        this.checkComponentActive();
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(input);
        if (attributeCtx == null) {
            this.log.warn("No AttributeContext found");
            return null;
        }
        if (attributeCtx.getIdPAttributes().isEmpty()) {
            this.log.warn("No filtered IdPAttributes found in AttributeContext");
            return null;
        }
        HashSet<Principal> accumulator = new HashSet<Principal>();
        attributeCtx.getIdPAttributes().values().stream().filter(a -> this.attributeSourceIDs.contains(a.getId())).forEach(a -> this.addMappedValues((Set<Principal>)accumulator, (IdPAttribute)a));
        return accumulator.isEmpty() ? null : accumulator;
    }

    private void addMappedValues(@Nonnull Set<Principal> results, @Nonnull IdPAttribute source) {
        source.getValues().stream().filter(StringAttributeValue.class::isInstance).map(StringAttributeValue.class::cast).map(StringAttributeValue::getValue).forEach(v -> {
            if (this.valueMappings.containsKey(v)) {
                String mapped = this.valueMappings.get(v);
                if (mapped != null) {
                    this.log.debug("Attrbute value for {} mapped to AuthnContextClassRef {}", (Object)source.getId(), (Object)mapped);
                    results.add((Principal)((Object)new AuthnContextClassRefPrincipal(mapped)));
                } else {
                    this.log.debug("Skipping suppressed attribute value for {}", (Object)source.getId());
                }
            } else {
                String trimmed = StringSupport.trimOrNull((String)v);
                if (trimmed != null) {
                    this.log.debug("Attrbute value for {} passed through as AuthnContextClassRef {}", (Object)source.getId(), (Object)trimmed);
                    results.add((Principal)((Object)new AuthnContextClassRefPrincipal(trimmed)));
                }
            }
        });
    }
}

