/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;

public final class AuthnContextClassRefPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String authnContextClassRef;

    public AuthnContextClassRefPrincipal(@Nonnull @ParameterName(name="classRef") @NotEmpty String classRef) {
        this.authnContextClassRef = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)classRef), (String)"AuthnContextClassRef cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.authnContextClassRef;
    }

    @Nonnull
    public AuthnContextClassRef getAuthnContextClassRef() {
        AuthnContextClassRef ref = (AuthnContextClassRef)((XMLObjectBuilder)Constraint.isNotNull((Object)XMLObjectSupport.getBuilder((QName)AuthnContextClassRef.DEFAULT_ELEMENT_NAME), (String)"No builder for AuthnContextClassRef")).buildObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.getName());
        return ref;
    }

    public int hashCode() {
        return this.authnContextClassRef.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AuthnContextClassRefPrincipal) {
            return this.authnContextClassRef.equals(((AuthnContextClassRefPrincipal)other).getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnContextClassRef", (Object)this.authnContextClassRef).toString();
    }

    @Nonnull
    public AuthnContextClassRefPrincipal clone() throws CloneNotSupportedException {
        AuthnContextClassRefPrincipal copy = (AuthnContextClassRefPrincipal)super.clone();
        copy.authnContextClassRef = this.authnContextClassRef;
        return copy;
    }
}

