/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.context;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.spring.context.DeferPlaceholderFileSystemXmlWebApplicationContext;
import net.shibboleth.shared.spring.custom.LocalOnlyResourceEntityResolver;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.xml.sax.EntityResolver;

public class DelimiterAwareApplicationContext
extends DeferPlaceholderFileSystemXmlWebApplicationContext {
    public void setConfigLocation(@Nonnull String location) {
        this.setConfigLocations(StringUtils.tokenizeToStringArray((String)location, (String)this.getDelimiters()));
    }

    @Nonnull
    protected String getDelimiters() {
        return ",;\t\n";
    }

    protected void loadBeanDefinitions(@Nonnull DefaultListableBeanFactory beanFactory) throws BeansException, IOException {
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setEnvironment((Environment)this.getEnvironment());
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        beanDefinitionReader.setEntityResolver((EntityResolver)((Object)new LocalOnlyResourceEntityResolver((ResourceLoader)this)));
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }
}

