/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.nameid.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.saml2.nameid.transcoding.AbstractSAML2NameIDTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;

public class SAML2StringNameIDTranscoder
extends AbstractSAML2NameIDTranscoder<StringAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_TEMPLATE = "saml2.valueTemplate";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE = "$Name!!$NameQualifier!!$SPNameQualifier";

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof StringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull StringAttributeValue value) throws AttributeEncodingException {
        throw new AttributeEncodingException("NameID transcoders do not support encoding");
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull NameID nameID, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        StringBuilder builder = new StringBuilder((String)rule.getOrDefault(PROP_TEMPLATE, String.class, (Object)DEFAULT_TEMPLATE));
        Boolean flag = (Boolean)rule.getOrDefault("saml2.defaultQualifiers", Boolean.class, (Object)false);
        assert (flag != null);
        int i = builder.indexOf("$Format");
        if (i >= 0) {
            String format = nameID.getFormat();
            builder.replace(i, i + 7, format != null ? format : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        if ((i = builder.indexOf("$SPNameQualifier")) >= 0) {
            builder.replace(i, i + 16, this.getSPNameQualifier(profileRequestContext, nameID, flag));
        }
        if ((i = builder.indexOf("$NameQualifier")) >= 0) {
            builder.replace(i, i + 14, this.getNameQualifier(profileRequestContext, nameID, flag));
        }
        if ((i = builder.indexOf("$Name")) >= 0) {
            String val = nameID.getValue();
            builder.replace(i, i + 5, val != null ? val : "");
        }
        return StringAttributeValue.valueOf((String)builder.toString());
    }
}

