/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class PluginInstallerArguments
extends AbstractIdPHomeAwareCommandLineArguments {
    @Nullable
    private Logger log;
    @Parameter(names={"-p", "--pluginId"})
    @Nullable
    private String pluginId;
    @Parameter(names={"--noPrompt"})
    private boolean noPrompt;
    @Parameter(names={"-l", "--list"})
    private boolean list;
    @Parameter(names={"-L", "--list-available"})
    private boolean listAvailable;
    @Parameter(names={"--noCheck"})
    private boolean noCheck;
    @Parameter(names={"-fl", "--full-list"})
    private boolean fullList;
    @Parameter(names={"--license"})
    @Nullable
    private String license;
    @Parameter(names={"-i", "--input"})
    @Nullable
    private String input;
    @Parameter(names={"-I", "--install-ID"})
    @Nullable
    private String installId;
    @Parameter(names={"--truststore"})
    @Nullable
    private String truststore;
    @Parameter(names={"-u", "--update"})
    @Nullable
    private String updatePluginId;
    @Parameter(names={"-fu", "--force-update"})
    @Nullable
    private String forceUpdateVersion;
    @Parameter(names={"-r", "--uninstall", "--remove"})
    @Nullable
    private String uninstallId;
    @Parameter(names={"-cl", "--contents-list"})
    @Nullable
    private String contentsList;
    @Parameter(names={"--updateURL"})
    @Nullable
    private String updateURL;
    @Parameter(names={"--noRebuild", "--no-rebuild"})
    private boolean noRebuild;
    @Nullable
    private InstallableComponentVersion updateVersion;
    @Nullable
    private String inputName;
    @Nullable
    private Path inputDirectory;
    @Nullable
    private URL inputURL;
    @Nonnull
    private OperationType operation = OperationType.UNKNOWN;

    @Nonnull
    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(PluginInstallerArguments.class);
        }
        assert (this.log != null);
        return this.log;
    }

    @Nullable
    public String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public String getTruststore() {
        return this.truststore;
    }

    @Nonnull
    public URL getInputURL() {
        URL result = this.inputURL;
        Constraint.isTrue((this.operation == OperationType.INSTALLREMOTE ? 1 : 0) != 0, (String)"Can only call getInputURL on remote operations");
        Constraint.isTrue((result != null ? 1 : 0) != 0, (String)"Invalid Remote URL");
        assert (result != null);
        return result;
    }

    @Nonnull
    public String getInputFileName() {
        String result = this.inputName;
        Constraint.isTrue((this.operation == OperationType.INSTALLREMOTE || this.operation == OperationType.INSTALLDIR ? 1 : 0) != 0, (String)"Can only call getInputFileName on remote or local installs");
        Constraint.isTrue((result != null ? 1 : 0) != 0, (String)"Invalid InputFileName");
        assert (result != null);
        return result;
    }

    @Nonnull
    public Path getInputDirectory() {
        Path result = this.inputDirectory;
        Constraint.isTrue((this.operation == OperationType.INSTALLDIR ? 1 : 0) != 0, (String)"Can only call getInputDirectory on local installs");
        Constraint.isTrue((result != null ? 1 : 0) != 0, (String)"Invalid InputDirectory");
        assert (result != null);
        return result;
    }

    public boolean isFullList() {
        return this.fullList;
    }

    public boolean isListAvailable() {
        return this.listAvailable;
    }

    public boolean isInstallId() {
        return StringSupport.trimOrNull((String)this.installId) != null;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isNoCheck() {
        return this.noCheck;
    }

    public boolean isUnattended() {
        return this.noPrompt;
    }

    @Nullable
    public InstallableComponentVersion getUpdateVersion() {
        return this.updateVersion;
    }

    @Nullable
    public String getUpdateURL() {
        return StringSupport.trimOrNull((String)this.updateURL);
    }

    @Nonnull
    public OperationType getOperation() {
        return this.operation;
    }

    public boolean isRebuild() {
        return !this.noRebuild;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.list || this.fullList || this.listAvailable) {
            this.operation = OperationType.LIST;
            if (this.input != null || this.uninstallId != null) {
                this.getLog().error("Cannot List and Install or Remove in the same operation.");
                throw new IllegalArgumentException("Cannot List and Install or Remove in the same operation.");
            }
            if (this.updatePluginId != null || this.uninstallId != null) {
                this.getLog().error("Cannot List and Update or Remove in the same operation.");
                throw new IllegalArgumentException("Cannot List and Update or Remove in the same operation.");
            }
        } else if (this.input != null) {
            if (this.updatePluginId != null || this.uninstallId != null) {
                this.getLog().error("Cannot Install and Update or Remove in the same operation.");
                throw new IllegalArgumentException("Cannot List and Update or Remove in the same operation.");
            }
            this.operation = this.decodeInput();
        } else if (this.installId != null) {
            this.operation = OperationType.INSTALLREMOTE;
            this.pluginId = this.installId;
        } else if (this.updatePluginId != null) {
            if (this.uninstallId != null) {
                this.getLog().error("Cannot Update and Remove in the same operation.");
                throw new IllegalArgumentException("Cannot Update and Remove in the same operation.");
            }
            this.pluginId = this.updatePluginId;
            this.operation = OperationType.UPDATE;
            if (this.forceUpdateVersion != null) {
                this.updateVersion = new InstallableComponentVersion(this.forceUpdateVersion);
            }
        } else if (this.uninstallId != null) {
            this.pluginId = this.uninstallId;
            this.operation = OperationType.UNINSTALL;
        } else if (this.license != null) {
            this.pluginId = this.license;
            this.operation = OperationType.OUTPUTLICENSE;
        } else if (this.contentsList != null) {
            this.pluginId = this.contentsList;
            this.operation = OperationType.LISTCONTENTS;
        } else {
            throw new IllegalArgumentException("Missing qualifier. Try  --help");
        }
    }

    @Nonnull
    private OperationType decodeInput() {
        try {
            String urlInput = this.input;
            assert (urlInput != null);
            URL inputAsURL = new URL(urlInput);
            if ("https".equals(inputAsURL.getProtocol()) || "http".equals(inputAsURL.getProtocol())) {
                int i = urlInput.lastIndexOf(47) + 1;
                this.inputURL = new URL(urlInput.substring(0, i));
                this.inputName = urlInput.substring(i);
                this.getLog().trace("Found URL: {}\t{}", (Object)this.inputDirectory, (Object)this.inputName);
                return OperationType.INSTALLREMOTE;
            }
        }
        catch (MalformedURLException urlInput) {
            // empty catch block
        }
        File inputAsFile = new File(this.input);
        if (!inputAsFile.exists()) {
            this.getLog().error("File {} does not exist", (Object)inputAsFile.getAbsolutePath());
            throw new IllegalArgumentException("Input File does not exist");
        }
        String inputAsFileString = inputAsFile.getAbsolutePath();
        assert (inputAsFileString != null);
        Path inputAsPath = InstallerSupport.pathOf(inputAsFileString);
        this.inputDirectory = inputAsPath.getParent();
        this.inputName = inputAsPath.getFileName().toString();
        this.getLog().trace("Found File: {}\t{}", (Object)this.inputDirectory, (Object)this.inputName);
        return OperationType.INSTALLDIR;
    }

    public void printHelp(@Nonnull PrintStream out) {
        out.println("Plugin");
        out.println("Provides a command line interface for plugin management operations.");
        out.println();
        out.println("   Plugin [options] springConfiguration [FullName]");
        out.println();
        out.println("      springConfiguration      name of Spring configuration resource to use");
        super.printHelp(out);
        out.println();
        out.println(String.format("  %-22s %s", "-l, --list", "Brief Information of all installed plugins"));
        out.println(String.format("  %-22s %s", "-fl, --full-list", "Full details of all installed plugins"));
        out.println(String.format("  %-22s %s", "-L, --list-available", "List plugins available to download."));
        out.println(String.format("  %-22s %s", "-cl, --contents-list", "Details of what was installed"));
        out.println(String.format("  %-22s %s", "-i, --input <what>", "Install (file name or web address)"));
        out.println(String.format("  %-22s %s", "-I, --install-ID <what>", "Install PluginID (must be available at download URL)"));
        out.println(String.format("  %-22s %s", "--noCheck", "Do not check the version"));
        out.println(String.format("  %-22s %s", "-u, --update <PluginId>", "update"));
        out.println(String.format("  %-22s %s", "--noRebuild", "do NOT rebuild war"));
        out.println(String.format("  %-22s %s", "-fu, --force-update <version>", "force version to update to (requires -u)"));
        out.println(String.format("  %-22s %s", "-r, --remove, --uninstall <PluginId>", "Uninstall plugin from the war file. \n\t\t\tDOES NOT UNDO any other installation"));
        out.println(String.format("  %-22s %s", "--license <pluginid>", "Output all licenses for this plugin"));
        out.println(String.format("  %-22s %s", "--noPrompt", "Unattended Install"));
        out.println(String.format("  %-22s %s", "--truststore <path>", "Explicit location to look for keys (should exist but may be an empty file)"));
        out.println(String.format("  %-22s %s", "--updateURL <URL>", "Explicit location to look for update information (overrides the plugin's value)"));
        out.println();
    }

    public static enum OperationType {
        UPDATE,
        LIST,
        INSTALLDIR,
        INSTALLREMOTE,
        UNINSTALL,
        OUTPUTLICENSE,
        LISTCONTENTS,
        UNKNOWN;

    }
}

