/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.TrustStore;
import net.shibboleth.idp.installer.impl.BuildWar;
import net.shibboleth.idp.installer.plugin.impl.LoggingVisitor;
import net.shibboleth.idp.installer.plugin.impl.PluginState;
import net.shibboleth.idp.installer.plugin.impl.RollbackPluginInstall;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.tools.ant.BuildException;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

public final class PluginInstaller
extends AbstractInitializableComponent
implements AutoCloseable {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(PluginInstaller.class);
    @Nonnull
    @NotEmpty
    private static final String PLUGIN_VERSION_PROPERTY = "idp.plugin.version";
    @Nonnull
    @NotEmpty
    private static final String PLUGIN_FILE_PROPERTY_PREFIX = "idp.plugin.file.";
    @Nonnull
    @NotEmpty
    private static final String PLUGIN_RELATIVE_PATHS_PROPERTY = "idp.plugin.relativePaths";
    @NonnullAfterInit
    private Path idpHome;
    private String pluginId;
    private Path unpackDirectory;
    private Path downloadDirectory;
    private IdPPlugin description;
    @Nonnull
    private Predicate<String> acceptKey = PredicateSupport.alwaysFalse();
    private Path distribution;
    private String truststore;
    @Nonnull
    private final HttpClient httpClient;
    @Nonnull
    private List<URL> updateOverrideURLs = CollectionSupport.emptyList();
    @NonnullAfterInit
    private Path workspacePath;
    @NonnullAfterInit
    private Path distPath;
    @NonnullAfterInit
    private Path pluginsWebapp;
    @NonnullAfterInit
    private Path pluginsContents;
    @Nullable
    private List<Path> installedContents;
    @Nullable
    private String installedVersionFromContents;
    @NonnullAfterInit
    private ModuleContext moduleContext;
    @Nonnull
    private Set<String> reenabledPluginModules = new HashSet<String>();
    @Nonnull
    private final Map<Module.ModuleResource, Module.ResourceResult> moduleChanges = new HashMap<Module.ModuleResource, Module.ResourceResult>();
    @Nullable
    private URLClassLoader installedPluginsLoader;
    @Nullable
    private URLClassLoader installingPluginLoader;
    @Nullable
    private HttpClientSecurityParameters securityParams;
    private boolean rebuildWar = true;

    public PluginInstaller(@Nonnull HttpClient client) {
        this.httpClient = client;
    }

    public void setIdpHome(@Nonnull Path home) {
        this.checkSetterPreconditions();
        this.idpHome = (Path)Constraint.isNotNull((Object)home, (String)"IdPHome should be non-null");
    }

    @Nonnull
    private Path getIdpHome() {
        assert (this.idpHome != null);
        return this.idpHome;
    }

    public void setPluginId(@Nonnull @NotEmpty String id) {
        this.pluginId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Plugin id should be be non-null");
    }

    public void setTrustore(@Nullable String loc) {
        this.truststore = StringSupport.trimOrNull((String)loc);
    }

    public void setAcceptKey(@Nonnull Predicate<String> what) {
        this.acceptKey = (Predicate)Constraint.isNotNull(what, (String)"Accept Key Predicate should be non-null");
    }

    public void setUpdateOverrideURLs(@Nonnull List<URL> urls) {
        this.updateOverrideURLs = (List)Constraint.isNotNull(urls, (String)"Override URLS must be non null");
    }

    public void setModuleContextSecurityParams(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.securityParams = params;
    }

    public void setRebuildWar(boolean what) {
        this.rebuildWar = what;
    }

    public boolean isRebuildWar() {
        return this.rebuildWar;
    }

    public void installPlugin(@Nonnull URL baseURL, @Nonnull @NotEmpty String fileName, boolean checkVersion) throws BuildException {
        this.download(baseURL, fileName);
        assert (this.downloadDirectory != null);
        this.installPlugin(this.downloadDirectory, fileName, checkVersion);
    }

    public void installPlugin(@Nonnull Path base, @Nonnull @NotEmpty String fileName, boolean checkVersion) throws BuildException {
        if (!Files.exists(base.resolve(fileName), new LinkOption[0])) {
            LOG.error("Could not find distribution {}", (Object)base.resolve(fileName));
            throw new BuildException("Could not find distribution");
        }
        if (!Files.exists(base.resolve(fileName + ".asc"), new LinkOption[0])) {
            LOG.error("Could not find distribution {}", (Object)base.resolve(fileName + ".asc"));
            throw new BuildException("Could not find signature for distribution");
        }
        this.unpack(base, fileName);
        this.setupPluginId();
        this.checkSignature(base, fileName);
        this.setupDescriptionFromDistribution();
        if (checkVersion) {
            PluginState state = new PluginState(this.getDescription(), this.updateOverrideURLs);
            state.setHttpClient(this.httpClient);
            state.setHttpClientSecurityParameters(this.securityParams);
            try {
                state.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BuildException((Throwable)e);
            }
            InstallableComponentVersion pluginVersion = new InstallableComponentVersion((Plugin)this.getDescription());
            InstallableComponentVersion idpVersion = PluginInstaller.getIdPVersion();
            if (!state.getPluginInfo().isSupportedWithIdPVersion(pluginVersion, idpVersion)) {
                LOG.error("Plugin {} version {} is not supported with IdP version {}", new Object[]{this.pluginId, pluginVersion, idpVersion});
                throw new BuildException("Version Mismatch");
            }
        }
        LOG.info("Installing Plugin '{}' version {}.{}.{}", new Object[]{this.pluginId, this.getDescription().getMajorVersion(), this.getDescription().getMinorVersion(), this.getDescription().getPatchVersion()});
        Set<String> loadedModules = this.getLoadedModules();
        if (this.getVersionFromContents() == null) {
            this.getModuleContext().setOperationType(ModuleContext.OperationType.Install);
        } else {
            this.getModuleContext().setOperationType(ModuleContext.OperationType.Upgrade);
        }
        this.getModuleContext().setPluginId(this.pluginId);
        try (RollbackPluginInstall rollBack = new RollbackPluginInstall(this.getModuleContext(), this.moduleChanges);){
            this.uninstallOld(rollBack);
            this.checkRequiredModules(loadedModules);
            this.handlePackages(rollBack);
            this.installNew(rollBack);
            this.reEnableModules(loadedModules);
            this.saveCopiedFiles(rollBack.getFilesCopied());
            rollBack.completed();
        }
        if (this.isRebuildWar()) {
            BuildWar builder = new BuildWar(this.getIdpHome());
            builder.execute();
        } else {
            LOG.info("WAR file not rebuilt.");
        }
        this.emitModuleChanges();
    }

    public void uninstall() throws BuildException {
        String moduleId = null;
        String pId = this.pluginId;
        assert (pId != null);
        this.getModuleContext().setPluginId(pId);
        this.getModuleContext().setOperationType(ModuleContext.OperationType.Uninstall);
        this.description = this.getInstalledPlugin(pId);
        if (this.description == null) {
            LOG.warn("Description for {} not found", (Object)this.pluginId);
        } else {
            try (RollbackPluginInstall rollback = new RollbackPluginInstall(this.getModuleContext(), this.moduleChanges);){
                for (IdPModule module : this.getDescription().getDisableOnRemoval()) {
                    moduleId = module.getId();
                    this.captureChanges(module.disable(this.getModuleContext(), false));
                    rollback.getModulesDisabled().add(module);
                }
                rollback.completed();
            }
            catch (ModuleException e) {
                LOG.error("Uninstalling {}. Could not disable {}", new Object[]{this.pluginId, moduleId, e});
                LOG.error("Fix this and rerun");
                throw new BuildException((Throwable)e);
            }
        }
        if (this.getVersionFromContents() == null) {
            LOG.warn("Installed contents for {} not found", (Object)this.pluginId);
        } else {
            for (Path content : this.getInstalledContents()) {
                assert (content != null);
                if (!Files.exists(content, new LinkOption[0])) continue;
                try {
                    InstallerSupport.setReadOnly(content, false);
                    Files.deleteIfExists(content);
                }
                catch (IOException e) {
                    LOG.warn("Could not delete {}, deferring the delete", (Object)content.toString(), (Object)e);
                    content.toFile().deleteOnExit();
                }
            }
            if (this.isRebuildWar()) {
                BuildWar builder = new BuildWar(this.getIdpHome());
                builder.execute();
                LOG.info("Removed resources for {} from the WAR file.", (Object)this.pluginId);
            } else {
                LOG.info("Removed resources for {}. WAR file not rebuilt.", (Object)this.pluginId);
            }
        }
        this.pluginsContents.resolve(this.pluginId).toFile().deleteOnExit();
        this.emitModuleChanges();
    }

    private void setupDescriptionFromDistribution() throws BuildException {
        ServiceLoader<IdPPlugin> plugins = ServiceLoader.load(IdPPlugin.class, this.getDistributionLoader());
        Optional<IdPPlugin> first = plugins.findFirst();
        if (first.isEmpty()) {
            LOG.error("No Plugin services found in plugin distribution");
            throw new BuildException("No Plugin services found in plugin distribution");
        }
        for (IdPPlugin plugin : plugins) {
            LOG.debug("Found Service announcing itself as {}", (Object)plugin.getPluginId());
            if (this.pluginId.equals(plugin.getPluginId())) {
                this.description = plugin;
                return;
            }
            LOG.trace("Did not match {}", (Object)this.pluginId);
        }
        LOG.error("Looking in plugin distibution for a plugin called {}, but found a plugin called {}.", (Object)this.pluginId, (Object)first.get().getPluginId());
        throw new BuildException("Could not locate PluginDescription");
    }

    @Nonnull
    public List<Path> getInstalledContents() {
        this.loadCopiedFiles();
        assert (this.installedContents != null);
        return this.installedContents;
    }

    @Nullable
    public String getVersionFromContents() {
        this.loadCopiedFiles();
        return this.installedVersionFromContents;
    }

    @Nonnull
    private ModuleContext getModuleContext() {
        this.checkComponentActive();
        assert (this.moduleContext != null);
        return this.moduleContext;
    }

    @Nonnull
    private Path getPluginsWebapp() {
        this.checkComponentActive();
        assert (this.pluginsWebapp != null);
        return this.pluginsWebapp;
    }

    @Nonnull
    private IdPPlugin getDescription() {
        Constraint.isTrue((this.description != null ? 1 : 0) != 0, (String)"Invalid Plugin Id in Description");
        assert (this.description != null);
        return this.description;
    }

    @Nonnull
    public Set<String> getLoadedModules() throws BuildException {
        HashSet<String> enablededModules = new HashSet<String>();
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class, this.getInstalledPluginsLoader()).iterator();
        while (modules.hasNext()) {
            try {
                IdPModule module = modules.next();
                if (!module.isEnabled(this.getModuleContext())) continue;
                LOG.debug("Found Enabled Module {}", (Object)module.getId());
                enablededModules.add(module.getId());
            }
            catch (ServiceConfigurationError e) {
                LOG.error("Unable to instantiate IdPModule", (Throwable)e);
                throw new BuildException((Throwable)e);
            }
        }
        return enablededModules;
    }

    private void checkRequiredModules(@Nonnull Set<String> loadedModules) throws BuildException {
        for (String moduleId : this.getDescription().getRequiredModules()) {
            if (loadedModules.contains(moduleId)) continue;
            LOG.warn("Required module {} is missing or not enabled ", (Object)moduleId);
            Pair<String, String> pluginInfo = this.getModulePluginInfo(moduleId);
            if (pluginInfo != null) {
                LOG.warn("Module {} provided by plugin {} version {}", new Object[]{moduleId, pluginInfo.getFirst(), pluginInfo.getSecond()});
            }
            throw new BuildException("One or more required modules are not enabled");
        }
    }

    private Pair<String, String> getModulePluginInfo(String moduleId) throws BuildException {
        try {
            List sources = this.description.getModuleInfoSources();
            Properties props = null;
            for (URL url : sources) {
                LOG.debug("Loading info from {}", (Object)url);
                if (url == null) continue;
                try {
                    HTTPResource httpResource = new HTTPResource(this.httpClient, url);
                    HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
                    handler.setHttpClientSecurityParameters(this.securityParams);
                    handler.initialize();
                    httpResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
                    props = new Properties();
                    props.load(httpResource.getInputStream());
                    LOG.debug("Loaded {} properties", (Object)props.size());
                    break;
                }
                catch (IOException e) {
                    LOG.error("Could not open Module Resource at {} :", (Object)url, (Object)e);
                }
            }
            if (props == null || props.isEmpty()) {
                return null;
            }
            String version = props.getProperty(moduleId + ".version");
            String plugin = props.getProperty(moduleId + ".plugin");
            LOG.debug("Looked up {}, found {}, {}", new Object[]{moduleId, version, plugin});
            return new Pair((Object)plugin, (Object)version);
        }
        catch (IOException | ComponentInitializationException e) {
            LOG.error("Could not lookup up infomationa about {}, continuing", (Object)moduleId, (Object)e);
            return null;
        }
    }

    private void reEnableModules(Set<String> loadedModules) throws BuildException {
        try {
            Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class, this.getDistributionLoader()).iterator();
            LOG.debug("Reloading Plugin-supplied modules (if any)");
            while (modules.hasNext()) {
                IdPModule module = modules.next();
                if (this.pluginId.equals(module.getOwnerId())) {
                    String moduleId = module.getId();
                    if (this.reenabledPluginModules.contains(moduleId)) {
                        LOG.debug("Module {} already enabled by Plugin rule", (Object)moduleId);
                        continue;
                    }
                    if (!loadedModules.contains(module.getId())) {
                        LOG.debug("Module {} not previously enabled", (Object)moduleId);
                        continue;
                    }
                    LOG.debug("Re-enabling module {}", (Object)moduleId);
                    this.captureChanges(module.enable(this.getModuleContext(), true));
                    continue;
                }
                LOG.debug("Module {}, not provided by this plugin", (Object)module.getId());
            }
        }
        catch (ServiceConfigurationError | ModuleException e) {
            LOG.error("Unable to instantiate IdPModule", e);
            throw new BuildException(e);
        }
    }

    private void handlePackages(@Nonnull RollbackPluginInstall rollback) throws BuildException {
        Path renameTarget = this.workspacePath.resolve("dirRollback");
        assert (renameTarget != null);
        for (Plugin.Package pack : this.getDescription().getPackages()) {
            if (SystemUtils.IS_OS_WINDOWS && !pack.isWindows()) {
                LOG.debug("Package: skipping non-Windows resource {}", (Object)pack.getDestinationName());
                continue;
            }
            if (!SystemUtils.IS_OS_WINDOWS && !pack.isNonWindows()) {
                LOG.debug("Package: skipping Windows resource {}", (Object)pack.getDestinationName());
                continue;
            }
            try {
                Path to = this.idpHome.resolve(pack.getDestinationName());
                assert (to != null);
                if (!to.startsWith(this.idpHome.toString())) {
                    LOG.error("Package {} attempted to create file outside of IdP installation: {}", (Object)pack.getDestinationName(), (Object)to);
                    throw new BuildException("Plugin package asked to create file outside of IdP installation");
                }
                if (Files.exists(to, new LinkOption[0])) {
                    InstallerSupport.renameToTree(this.getIdpHome(), renameTarget, CollectionSupport.singletonList((Object)to), rollback.getFilesRenamedAway());
                }
                Path fromPackage = this.distribution.resolve(pack.getSourceName());
                assert (fromPackage != null);
                PluginInstaller.unpack(to, fromPackage, PluginInstaller.isZip(pack.getSourceName()), pack.isStripTopLevelDir());
            }
            catch (IOException e) {
                LOG.error("Unable to handle package : {} ", (Object)pack.getDestinationName(), (Object)e);
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void installNew(@Nonnull RollbackPluginInstall rollBack) throws BuildException {
        Path from = this.distribution.resolve("webapp");
        assert (from != null);
        if (InstallerSupport.detectDuplicates(from, this.getPluginsWebapp())) {
            throw new BuildException("Install would overwrite files");
        }
        InstallerSupport.copyWithLogging(from, this.getPluginsWebapp(), rollBack.getFilesCopied());
        String moduleId = null;
        try {
            for (IdPModule module : this.getDescription().getEnableOnInstall()) {
                moduleId = module.getId();
                if (!module.isEnabled(this.getModuleContext())) {
                    LOG.debug("Enabling Module {}", (Object)moduleId);
                    this.captureChanges(module.enable(this.getModuleContext(), false));
                    rollBack.getModulesEnabled().add(module);
                } else {
                    LOG.debug("Re-enabling Module {}", (Object)moduleId);
                    this.captureChanges(module.enable(this.getModuleContext(), true));
                }
                this.reenabledPluginModules.add(moduleId);
            }
        }
        catch (ModuleException e) {
            LOG.error("Error enabling {}", moduleId);
            throw new BuildException((Throwable)e);
        }
    }

    private void uninstallOld(@Nonnull RollbackPluginInstall rollback) throws BuildException {
        String oldVersion = this.getVersionFromContents();
        if (oldVersion == null) {
            LOG.debug("{} not installed. files renamed", (Object)this.pluginId);
        } else {
            try {
                Path rollbackDir = this.workspacePath.resolve("rollback");
                assert (rollbackDir != null);
                LOG.debug("Uninstalling version {} of {}", (Object)oldVersion, (Object)this.pluginId);
                InstallerSupport.renameToTree(this.getPluginsWebapp(), rollbackDir, this.getInstalledContents(), rollback.getFilesRenamedAway());
            }
            catch (IOException e) {
                LOG.error("Error uninstalling plugin", (Throwable)e);
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void saveCopiedFiles(@Nonnull List<Path> copiedFiles) throws BuildException {
        try {
            Files.createDirectories(this.pluginsContents, new FileAttribute[0]);
            Properties props = new Properties(1 + copiedFiles.size());
            props.setProperty(PLUGIN_VERSION_PROPERTY, new InstallableComponentVersion((Plugin)this.getDescription()).toString());
            props.setProperty(PLUGIN_RELATIVE_PATHS_PROPERTY, "true");
            int count = 1;
            for (Path p : copiedFiles) {
                Path relPath = this.getIdpHome().relativize(p);
                props.setProperty(PLUGIN_FILE_PROPERTY_PREFIX + Integer.toString(count++), relPath.toString());
            }
            File outFile = this.pluginsContents.resolve(this.pluginId).toFile();
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));){
                props.store(out, "Files Copied " + String.valueOf(Instant.now()));
            }
        }
        catch (IOException e) {
            LOG.error("Error saving list of copied files.", (Throwable)e);
            throw new BuildException((Throwable)e);
        }
    }

    @Nullable
    private Path inferInstalledIdpHome(@Nonnull Properties props) {
        if (props.get("idp.plugin.file.1") == null) {
            return null;
        }
        int count = 1;
        LOG.debug("Inferring IdP Home");
        String val = props.getProperty(PLUGIN_FILE_PROPERTY_PREFIX + Integer.toString(count++));
        while (val != null) {
            LOG.debug("Looking at {}", (Object)val);
            int index = val.indexOf("/dist/plugin-webapp/");
            if (index < 0) {
                index = val.indexOf("\\dist\\plugin-webapp\\");
            }
            if (index >= 0) {
                String s = val.substring(0, index);
                if (this.getIdpHome().toString().equals(s)) {
                    LOG.debug("Inferred install to {}", (Object)s);
                } else {
                    LOG.info("Inferred initial install to {}", (Object)s);
                }
                assert (s != null);
                return InstallerSupport.pathOf(s);
            }
            val = props.getProperty(PLUGIN_FILE_PROPERTY_PREFIX + Integer.toString(count++));
        }
        LOG.error("Could no infer IDPHOME from previous contents");
        return null;
    }

    private void loadCopiedFiles() throws BuildException {
        if (this.installedContents != null) {
            return;
        }
        Properties props = new Properties();
        File inFile = this.pluginsContents.resolve(this.pluginId).toFile();
        if (!inFile.exists()) {
            LOG.debug("Contents file for plugin {} ({}) does not exist", (Object)this.pluginId, (Object)inFile.getAbsolutePath());
            this.installedContents = CollectionSupport.emptyList();
            return;
        }
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(inFile));){
            props.load(inStream);
        }
        catch (IOException e) {
            LOG.error("Error loading list of copied files from {}.", (Object)inFile, (Object)e);
            throw new BuildException((Throwable)e);
        }
        LOG.debug("Property file {}", (Object)props);
        ArrayList<Path> result = new ArrayList<Path>(props.size());
        this.installedVersionFromContents = StringSupport.trimOrNull((String)props.getProperty(PLUGIN_VERSION_PROPERTY));
        boolean relativePaths = props.get(PLUGIN_RELATIVE_PATHS_PROPERTY) != null;
        Path installedIdPHome = relativePaths ? null : this.inferInstalledIdpHome(props);
        int count = 1;
        String val = props.getProperty(PLUGIN_FILE_PROPERTY_PREFIX + Integer.toString(count++));
        while (val != null) {
            Path valAsPath = InstallerSupport.pathOf(val);
            if (relativePaths || installedIdPHome == null) {
                result.add(this.getIdpHome().resolve(valAsPath));
            } else {
                Path relPath = installedIdPHome.relativize(valAsPath);
                Path newPath = this.getIdpHome().resolve(relPath);
                result.add(newPath);
            }
            val = props.getProperty(PLUGIN_FILE_PROPERTY_PREFIX + Integer.toString(count++));
        }
        this.installedContents = result;
    }

    private void download(@Nonnull URL baseURL, @Nonnull String fileName) throws BuildException {
        try {
            Path dir = this.downloadDirectory = Files.createTempDirectory("plugin-installer-download", new FileAttribute[0]);
            assert (dir != null);
            HTTPResource baseResource = new HTTPResource(this.httpClient, baseURL);
            HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
            handler.setHttpClientSecurityParameters(this.securityParams);
            handler.initialize();
            baseResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
            InstallerSupport.download(baseResource, handler, dir, fileName);
            InstallerSupport.download(baseResource, handler, dir, fileName + ".asc");
        }
        catch (IOException | ComponentInitializationException e) {
            LOG.error("Error in download", e);
            throw new BuildException(e);
        }
    }

    private void captureChanges(@Nonnull Map<Module.ModuleResource, Module.ResourceResult> changes) {
        for (Map.Entry<Module.ModuleResource, Module.ResourceResult> entry : changes.entrySet()) {
            this.moduleChanges.put(entry.getKey(), entry.getValue());
        }
    }

    private void emitModuleChanges() {
        if (!this.moduleChanges.isEmpty()) {
            LOG.info("Module file changes as a result of this install");
            this.moduleChanges.forEach(this::doReportOperation);
        }
    }

    private void doReportOperation(@Nonnull Module.ModuleResource resource, @Nonnull Module.ResourceResult result) {
        String dest = resource.getDestination().toString();
        switch (result) {
            case CREATED: {
                LOG.info("\t{} created", (Object)dest);
                break;
            }
            case REPLACED: {
                LOG.info("\t{} replaced, {}.idpsave created", (Object)dest, (Object)dest);
                break;
            }
            case ADDED: {
                LOG.info("\t{}.idpnew created", (Object)dest);
                break;
            }
            case REMOVED: {
                LOG.info("\t{} removed", (Object)dest);
                break;
            }
            case SAVED: {
                LOG.info("\t{} renamed to, {}.idpsave", (Object)dest, (Object)dest);
                break;
            }
            case MISSING: {
                LOG.info("\t{} missing, nothing to do", (Object)dest);
                break;
            }
        }
    }

    private void unpack(@Nonnull Path base, @Nonnull String fileName) throws BuildException {
        Path fullName = base.resolve(fileName);
        assert (fullName != null);
        Constraint.isNull((Object)this.unpackDirectory, (String)"cannot unpack multiple times");
        try {
            Path upDir = this.unpackDirectory = Files.createTempDirectory("plugin-installer-unpack", new FileAttribute[0]);
            assert (upDir != null);
            boolean isZip = PluginInstaller.isZip(fileName);
            if (isZip) {
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLI_OPTION, (String)"zip Plugin Distributions", null, (String)"tar.gz distribution");
            }
            PluginInstaller.unpack(upDir, fullName, isZip, false);
            try (DirectoryStream<Path> unpackDirStream = Files.newDirectoryStream(upDir);){
                Iterator<Path> contents = unpackDirStream.iterator();
                if (!contents.hasNext()) {
                    LOG.error("No contents unpacked from {}", (Object)fullName);
                    throw new BuildException("Distro was empty");
                }
                Path next = contents.next();
                assert (next != null);
                this.distribution = InstallerSupport.canonicalPath(next);
                if (contents.hasNext()) {
                    LOG.error("Too many packages in distributions {}", (Object)fullName);
                    throw new BuildException("Too many packages in distributions");
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static void unpack(@Nonnull Path unpackTo, @Nonnull Path fullName, boolean isZip, boolean stripFirst) throws BuildException {
        LOG.debug("Unpacking {} to {}", (Object)fullName, (Object)unpackTo);
        try (ArchiveInputStream<?> inStream = PluginInstaller.getStreamFor(fullName, isZip);){
            ArchiveEntry entry = null;
            while ((entry = inStream.getNextEntry()) != null) {
                if (!inStream.canReadEntryData(entry)) {
                    LOG.warn("Could not read next entry from {}", inStream);
                    continue;
                }
                Path fromPath = unpackTo;
                if (stripFirst) {
                    String[] names = entry.getName().split("/");
                    for (int i = 1; i < names.length; ++i) {
                        fromPath = fromPath.resolve(names[i]);
                    }
                } else {
                    fromPath = fromPath.resolve(entry.getName());
                }
                File output = unpackTo.resolve(fromPath).toFile();
                LOG.trace("Unpacking {} to {}", (Object)entry.getName(), (Object)output);
                if (entry.isDirectory()) {
                    if (output.isDirectory() || output.mkdirs()) continue;
                    LOG.error("Failed to create directory {}", (Object)output);
                    throw new BuildException("failed to create unpacked directory");
                }
                File parent = output.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    LOG.error("Failed to create parent directory {}", (Object)parent);
                    throw new BuildException("failed to create unpacked directory");
                }
                OutputStream outStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);
                try {
                    IOUtils.copy(inStream, (OutputStream)outStream);
                }
                finally {
                    if (outStream == null) continue;
                    outStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static boolean isZip(@Nonnull String fileName) throws BuildException {
        if (fileName.length() <= 7) {
            LOG.error("Improbably small file name: {}", (Object)fileName);
            throw new BuildException("Improbably small file name");
        }
        if (".zip".equalsIgnoreCase(fileName.substring(fileName.length() - 4))) {
            return true;
        }
        if (!".tar.gz".equalsIgnoreCase(fileName.substring(fileName.length() - 7))) {
            LOG.warn("FileName {} did not end with .zip or .tar.gz, assuming tar-gz", (Object)fileName);
        }
        return false;
    }

    @Nonnull
    private static ArchiveInputStream<?> getStreamFor(@Nonnull Path fullName, boolean isZip) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fullName.toFile()));
        if (isZip) {
            return new ZipArchiveInputStream((InputStream)inStream);
        }
        return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)inStream));
    }

    private void setupPluginId() throws BuildException {
        File propertyFile = this.distribution.resolve("bootstrap").resolve("plugin.properties").toFile();
        if (!propertyFile.exists()) {
            LOG.error("Could not locate identity of plugin. Identity file 'bootstrap/plugin.properties' not present in plugin distribution.");
            throw new BuildException("Could not locate identity of plugin");
        }
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(propertyFile));){
            Properties idProperties = new Properties();
            idProperties.load(inStream);
            String id = StringSupport.trimOrNull((String)idProperties.getProperty("plugin.id"));
            if (id == null) {
                LOG.error("Identity property file 'bootstrap/id.property' did not contain 'pluginid' property");
                throw new BuildException("No property in ID file");
            }
            if (this.pluginId != null && !this.pluginId.equals(id)) {
                LOG.error("Downloaded plugin id {} overriden by provided id {}", (Object)id, (Object)this.pluginId);
            } else {
                this.setPluginId(id);
            }
        }
        catch (IOException e) {
            LOG.error("Could not load plugin identity file 'bootstrap/id.property'", (Throwable)e);
            throw new BuildException((Throwable)e);
        }
    }

    private void checkSignature(@Nonnull Path base, @Nonnull String fileName) throws BuildException {
        try (BufferedInputStream sigStream = new BufferedInputStream(new FileInputStream(base.resolve(fileName + ".asc").toFile()));){
            TrustStore trust = new TrustStore();
            trust.setIdpHome(this.getIdpHome());
            trust.setTrustStore(this.truststore);
            trust.setPluginId(this.pluginId);
            trust.initialize();
            TrustStore.Signature sig = TrustStore.signatureOf(sigStream);
            if (!trust.contains(sig)) {
                LOG.info("TrustStore does not contain signature {}", (Object)sig);
                File keys = this.distribution.resolve("bootstrap").resolve("keys.txt").toFile();
                if (!keys.exists()) {
                    LOG.info("No embedded keys file, signature check fails");
                    throw new BuildException("No key found to check signiture of distribution");
                }
                try (BufferedInputStream keysStream = new BufferedInputStream(new FileInputStream(keys));){
                    trust.importKeyFromStream(sig, keysStream, this.acceptKey);
                }
                if (!trust.contains(sig)) {
                    LOG.info("Key not added to Trust Store");
                    throw new BuildException("Could not check signature of distribution");
                }
            }
            try (BufferedInputStream distroStream = new BufferedInputStream(new FileInputStream(base.resolve(fileName).toFile()));){
                if (!trust.checkSignature(distroStream, sig)) {
                    LOG.info("Signature checked for {} failed", (Object)fileName);
                    throw new BuildException("Signature check failed");
                }
            }
        }
        catch (IOException | ComponentInitializationException e) {
            LOG.error("Could not manage truststore for [{}, {}] ", new Object[]{this.idpHome, this.pluginId, e});
            throw new BuildException(e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        Path wsp;
        Path myIdpHome = this.idpHome;
        if (myIdpHome == null) {
            throw new ComponentInitializationException("idp.home property must be set");
        }
        try {
            this.idpHome = myIdpHome = InstallerSupport.canonicalPath(myIdpHome);
        }
        catch (IOException e) {
            LOG.error("Could not canonicalize idp home", (Throwable)e);
            throw new ComponentInitializationException((Exception)e);
        }
        String idpHomeString = myIdpHome.toString();
        assert (idpHomeString != null);
        this.moduleContext = new ModuleContext(idpHomeString);
        this.moduleContext.setHttpClientSecurityParameters(this.securityParams);
        this.moduleContext.setHttpClient(this.httpClient);
        this.distPath = this.idpHome.resolve("dist");
        try {
            wsp = this.workspacePath = Files.createTempDirectory("plugin-installer-workspace", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ComponentInitializationException((Exception)e);
        }
        Path pwp = this.pluginsWebapp = this.distPath.resolve("plugin-webapp");
        Path pcp = this.pluginsContents = this.distPath.resolve("plugin-contents");
        assert (wsp != null && pwp != null && pcp != null && this.distPath != null);
        InstallerSupport.setReadOnly(this.distPath, false);
        InstallerSupport.setMode(wsp, "640", "**/*");
        InstallerSupport.setMode(pwp, "640", "**/*");
        InstallerSupport.setMode(pcp, "640", "**/*");
    }

    @Nonnull
    private synchronized URLClassLoader getInstalledPluginsLoader() throws BuildException {
        URL[] urls;
        if (this.installedPluginsLoader != null) {
            return this.installedPluginsLoader;
        }
        Path libs = this.getPluginsWebapp().resolve("WEB-INF").resolve("lib");
        if (Files.exists(libs, new LinkOption[0])) {
            try {
                if (!Files.exists(this.workspacePath, new LinkOption[0])) {
                    Files.createDirectories(this.workspacePath, new FileAttribute[0]);
                }
                Path pathToDir = Files.createTempDirectory(this.workspacePath, "classpath", new FileAttribute[0]);
                assert (libs != null && pathToDir != null);
                LoggingVisitor visitor = new LoggingVisitor(libs, pathToDir);
                try (DirectoryStream<Path> webInfLibs = Files.newDirectoryStream(libs);){
                    for (Path jar : webInfLibs) {
                        visitor.visitFile(jar, (BasicFileAttributes)null);
                    }
                }
                urls = (URL[])visitor.getCopiedList().stream().map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e1) {
                        throw new BuildException((Throwable)e1);
                    }
                }).toArray(URL[]::new);
            }
            catch (IOException e) {
                LOG.error("Error finding Plugins' classpath");
                throw new BuildException((Throwable)e);
            }
        }
        urls = new URL[]{};
        this.installedPluginsLoader = new URLClassLoader(urls);
        return this.installedPluginsLoader;
    }

    @Nonnull
    private synchronized URLClassLoader getDistributionLoader() throws BuildException {
        URLClassLoader uRLClassLoader;
        block10: {
            if (this.installingPluginLoader != null) {
                return this.installingPluginLoader;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            Path libDir = this.distribution.resolve("webapp").resolve("WEB-INF").resolve("lib");
            DirectoryStream<Path> libDirPaths = Files.newDirectoryStream(libDir);
            try {
                for (Path jar : libDirPaths) {
                    urls.add(jar.toUri().toURL());
                }
                this.installingPluginLoader = new URLClassLoader((URL[])urls.toArray(URL[]::new));
                uRLClassLoader = this.installingPluginLoader;
                if (libDirPaths == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (libDirPaths != null) {
                        try {
                            libDirPaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error building Plugin Installation ClassPathLoader");
                    throw new BuildException((Throwable)e);
                }
            }
            libDirPaths.close();
        }
        return uRLClassLoader;
    }

    @Nonnull
    public List<IdPPlugin> getInstalledPlugins() throws BuildException {
        Stream<ServiceLoader.Provider<IdPPlugin>> loaderStream = ServiceLoader.load(IdPPlugin.class, this.getInstalledPluginsLoader()).stream();
        return (List)((NonnullSupplier)loaderStream.map(ServiceLoader.Provider::get).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }

    @Nullable
    public IdPPlugin getInstalledPlugin(@Nonnull String name) {
        List<IdPPlugin> plugins = this.getInstalledPlugins();
        for (IdPPlugin plugin : plugins) {
            if (!plugin.getPluginId().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    private void closeSilently(@Nullable AutoCloseable what) {
        if (what == null) {
            return;
        }
        try {
            what.close();
        }
        catch (Exception e) {
            LOG.error("Autoclose of {} failed", (Object)what, (Object)e);
        }
    }

    @Override
    public void close() {
        this.closeSilently(this.installedPluginsLoader);
        this.closeSilently(this.installingPluginLoader);
        InstallerSupport.deleteTree(this.downloadDirectory);
        InstallerSupport.deleteTree(this.unpackDirectory);
        InstallerSupport.deleteTree(this.workspacePath);
        assert (this.distPath != null);
        InstallerSupport.setReadOnly(this.distPath, true);
    }

    @Nonnull
    protected static InstallableComponentVersion getIdPVersion() {
        String version = Version.getVersion();
        if (version == null) {
            LOG.error("Could not determine IdP Version. Assuming 5.0.0");
            LOG.error("You should never see this outside a test environment/");
            return new InstallableComponentVersion(5, 0, 0);
        }
        return new InstallableComponentVersion(version);
    }
}

