/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageMappingStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;

public final class ScriptedStorageMappingStrategy
extends AbstractScriptEvaluator
implements StorageMappingStrategy {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedStorageMappingStrategy.class);

    private ScriptedStorageMappingStrategy(@Nonnull EvaluableScript theScript) {
        super(theScript);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> map(@Nonnull StorageRecord<?> results) throws ResolutionException {
        this.log.debug("{} Handling StorageRecord", (Object)this.getLogPrefix());
        try {
            Object map = this.evaluate(new Object[]{results});
            if (map instanceof Map) {
                Map mapApMap = (Map)map;
                return mapApMap;
            }
            throw new ResolutionException(this.getLogPrefix() + "Script finalization did not return a map");
        }
        catch (RuntimeException e) {
            throw new ResolutionException(this.getLogPrefix() + " Script did not run successfully", (Exception)e);
        }
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        this.log.debug("{} Adding to-be-populated attribute set '{}' to script context", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
        scriptContext.setAttribute(RESULTS_STRING, new HashSet(), 100);
        scriptContext.setAttribute("record", input != null ? input[0] : null, 100);
        scriptContext.setAttribute("log", this.log, 100);
    }

    @Nullable
    protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
        Object res = scriptContext.getAttribute(RESULTS_STRING);
        if (null == res) {
            this.log.error("{} Could not locate output variable '{}' from script", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
            throw new ScriptException("Could not locate output from script");
        }
        if (!(res instanceof Collection)) {
            this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
            throw new ScriptException("Output was of the wrong type");
        }
        Collection outputCollection = (Collection)res;
        HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
        for (Object o : outputCollection) {
            if (o instanceof IdPAttribute) {
                IdPAttribute attribute = (IdPAttribute)o;
                this.checkValues(attribute);
                outputMap.put(attribute.getId(), attribute);
                continue;
            }
            this.log.warn("{} Output collection contained an object of type '{}', ignored", (Object)this.getLogPrefix(), o != null ? o.getClass().getName() : null);
        }
        return outputMap;
    }

    private void checkValues(@Nonnull IdPAttribute attribute) {
        this.log.debug("{} Attribute '{}' has {} value(s).", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
        List inputValues = attribute.getValues();
        ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
        for (Object o : inputValues) {
            if (o instanceof IdPAttributeValue) {
                outputValues.add((IdPAttributeValue)o);
                continue;
            }
            this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
        }
        attribute.setValues(outputValues);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedStorageMappingStrategy scriptedStorageMappingStrategy = new ScriptedStorageMappingStrategy(script);
            return scriptedStorageMappingStrategy;
        }
    }

    @Nonnull
    static ScriptedStorageMappingStrategy resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedStorageMappingStrategy.resourceScript("JavaScript", resource);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedStorageMappingStrategy(script);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        return ScriptedStorageMappingStrategy.inlineScript("JavaScript", scriptSource);
    }
}

