/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.util.impl;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class SubjectMatchProcessor {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SubjectMatchProcessor.class);

    public void process(@Nonnull ResponseData responseData) {
        MessageContext outboundContext = responseData.getSOAPClientContext().getOutboundMessageContext();
        assert (outboundContext != null);
        AttributeQuery query = (AttributeQuery)outboundContext.getMessage();
        assert (query != null);
        Subject querySubject = query.getSubject();
        assert (querySubject != null);
        if (this.log.isTraceEnabled()) {
            try {
                this.log.trace("Matching Assertions' subject(s) against query Subject:\n{})", (Object)SerializeSupport.prettyPrintXML((Node)XMLObjectSupport.marshall((XMLObject)querySubject)));
            }
            catch (MarshallingException e) {
                this.log.warn("Error serialzing query Subject for logging", (Throwable)e);
            }
        }
        LinkedList<Assertion> toRemove = new LinkedList<Assertion>();
        for (Assertion assertion : responseData.getResponse().getAssertions()) {
            if (this.subjectMatches(assertion, querySubject)) continue;
            Issuer assertionIssuer = assertion.getIssuer();
            this.log.warn("Subject of Assertion '{}' from Issuer '{}' did not match query Subject, removing", (Object)assertion.getID(), (Object)(assertionIssuer != null ? assertionIssuer.getValue() : "null"));
            toRemove.add(assertion);
        }
        if (!toRemove.isEmpty()) {
            responseData.getResponse().getAssertions().removeAll(toRemove);
            this.log.debug("Removed a total of {} assertions which failed subject match processing", (Object)toRemove.size());
        }
    }

    private boolean subjectMatches(@Nonnull Assertion assertion, @Nonnull Subject querySubject) {
        Subject assertionSubject = assertion.getSubject();
        if (assertionSubject == null) {
            Issuer assertionIssuer = assertion.getIssuer();
            this.log.warn("Assertion '{}' from Issuer '{}' did not contain Subject, removing", (Object)assertion.getID(), (Object)(assertionIssuer != null ? assertionIssuer.getValue() : "null"));
            return false;
        }
        if (this.log.isTraceEnabled()) {
            try {
                this.log.trace("Matching Assertion subject:\n{})", (Object)SerializeSupport.prettyPrintXML((Node)XMLObjectSupport.marshall((XMLObject)assertionSubject)));
            }
            catch (MarshallingException e) {
                this.log.warn("Error serialzing query Subject for logging", (Throwable)e);
            }
        }
        return SAML2ObjectSupport.matchSubject((Subject)assertionSubject, (Subject)querySubject, (boolean)false);
    }
}

