/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class PairwiseIdDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PairwiseIdDataConnector.class);
    @NonnullAfterInit
    private String generatedAttribute;
    @NonnullAfterInit
    private String sourceInformation;
    @NonnullAfterInit
    private PairwiseIdStore pidStore;

    @NonnullAfterInit
    public String getSourceAttributeInformation() {
        this.checkComponentActive();
        return this.sourceInformation;
    }

    @NonnullAfterInit
    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    public void setGeneratedAttributeId(@Nullable String newAttributeId) {
        this.checkSetterPreconditions();
        this.generatedAttribute = newAttributeId;
    }

    @NonnullAfterInit
    public PairwiseIdStore getPairwiseIdStore() {
        return this.pidStore;
    }

    public void setPairwiseIdStore(@Nonnull PairwiseIdStore store) {
        this.checkSetterPreconditions();
        this.pidStore = (PairwiseIdStore)Constraint.isNotNull((Object)store, (String)"PairwiseIdStore cannot be null");
    }

    private void doDependencyInformation() throws ComponentInitializationException {
        StringBuilder dependencyInformation = new StringBuilder();
        boolean seenAttribute = false;
        for (ResolverAttributeDefinitionDependency attrDep : this.getAttributeDependencies()) {
            if (seenAttribute) {
                dependencyInformation.append(", ");
            }
            dependencyInformation.append(attrDep.getDependencyPluginId());
            seenAttribute = true;
        }
        for (ResolverDataConnectorDependency dataConnectorDependency : this.getDataConnectorDependencies()) {
            if (seenAttribute) {
                dependencyInformation.append(", ");
            }
            if (dataConnectorDependency.isAllAttributes()) {
                dependencyInformation.append(dataConnectorDependency.getDependencyPluginId()).append("/*");
            } else {
                if (dataConnectorDependency.getAttributeNames().isEmpty()) {
                    throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present.");
                }
                if (dataConnectorDependency.getAttributeNames().size() == 1) {
                    dependencyInformation.append(dataConnectorDependency.getDependencyPluginId()).append('/').append((String)dataConnectorDependency.getAttributeNames().iterator().next());
                } else {
                    dependencyInformation.append(dataConnectorDependency.getDependencyPluginId()).append('/').append(dataConnectorDependency.getAttributeNames().toString());
                }
            }
            seenAttribute = true;
        }
        if (!seenAttribute) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present in the supplied Dependencies");
        }
        this.sourceInformation = dependencyInformation.toString();
        this.log.debug("{} Source for definition: {}", (Object)this.getLogPrefix(), (Object)this.sourceInformation);
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.pidStore == null) {
            throw new ComponentInitializationException("PairwiseIdStore cannot be null");
        }
        this.doDependencyInformation();
        super.doInitialize();
        if (null == this.generatedAttribute) {
            this.generatedAttribute = this.getId();
            this.log.info("{} No generated attribute ID supplied, using ID of connector: {}", (Object)this.getLogPrefix(), (Object)this.generatedAttribute);
        }
    }

    @Nullable
    protected String resolveSourceAttribute(@Nonnull AttributeResolverWorkContext workContext) {
        IdPAttributeValue attributeValue;
        this.checkComponentActive();
        List attributeValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.ensureId());
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("{} Source attribute {} for connector {} provide no values", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
            return null;
        }
        if (attributeValues.size() > 1) {
            this.log.warn("{} Source attribute {} for connector {} has more than one value, only one value is used", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
        }
        if ((attributeValue = (IdPAttributeValue)attributeValues.iterator().next()) instanceof StringAttributeValue) {
            if (StringSupport.trimOrNull((String)((StringAttributeValue)attributeValue).getValue()) == null) {
                this.log.warn("{} Source attribute {} for connector {} was all-whitespace", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
                return null;
            }
        } else {
            if (attributeValue instanceof EmptyAttributeValue) {
                EmptyAttributeValue emptyVal = (EmptyAttributeValue)attributeValue;
                this.log.warn("{} Source attribute {} value for connector {} was an empty value of type {}", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId(), emptyVal.getDisplayValue()});
                return null;
            }
            this.log.warn("{} Source attribute {} for connector {} was of an unsupported type: {}", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId(), attributeValue.getClass().getName()});
            return null;
        }
        String val = ((StringAttributeValue)attributeValue).getValue();
        return val;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        String principalName = resolutionContext.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            this.log.warn("{} No principal name available, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String attributeIssuerID = resolutionContext.getAttributeIssuerID();
        if (Strings.isNullOrEmpty((String)attributeIssuerID)) {
            this.log.warn("{} Could not get attribute issuer ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String attributeRecipientID = resolutionContext.getAttributeRecipientGroupID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            attributeRecipientID = resolutionContext.getAttributeRecipientID();
        }
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            this.log.warn("{} Could not get attribute recipient or group ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String sourceId = this.resolveSourceAttribute(workContext);
        if (Strings.isNullOrEmpty((String)sourceId)) {
            return null;
        }
        try {
            PairwiseId pid = new PairwiseId();
            pid.setIssuerEntityID(attributeIssuerID);
            pid.setRecipientEntityID(attributeRecipientID);
            pid.setPrincipalName(principalName);
            pid.setSourceSystemId(sourceId);
            pid = this.pidStore.getBySourceValue(pid, true);
            if (pid != null && pid.getPairwiseId() != null) {
                return this.encodeAsAttribute(pid.getPairwiseId());
            }
            this.log.warn("{} Pairwise ID store did not return a value", (Object)this.getLogPrefix());
            return null;
        }
        catch (IOException e) {
            throw new ResolutionException((Exception)e);
        }
    }

    @Nullable
    protected Map<String, IdPAttribute> encodeAsAttribute(@Nullable String value) {
        this.checkComponentActive();
        if (null == value) {
            return null;
        }
        String id = this.getGeneratedAttributeId();
        assert (id != null);
        IdPAttribute attribute = new IdPAttribute(id);
        attribute.setValues(CollectionSupport.singletonList((Object)StringAttributeValue.valueOf((String)value)));
        return CollectionSupport.singletonMap((Object)id, (Object)attribute);
    }
}

