/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public class PrescopedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrescopedAttributeDefinition.class);
    @Nonnull
    @NotEmpty
    private String scopeDelimiter = "@";

    @Nonnull
    @NotEmpty
    public String getScopeDelimiter() {
        return this.scopeDelimiter;
    }

    public void setScopeDelimiter(@Nonnull @NotEmpty String newScopeDelimiter) {
        this.checkSetterPreconditions();
        this.scopeDelimiter = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newScopeDelimiter), (String)(this.getLogPrefix() + " Scope delimiter can not be null or empty"));
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)(this.getLogPrefix() + " AttributeResolverWorkContext cannot be null"));
        this.checkComponentActive();
        IdPAttribute resultantAttribute = new IdPAttribute(this.ensureId());
        List dependencyValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.ensureId());
        this.log.debug("{} Dependencies provided unmapped values of {}", (Object)this.getLogPrefix(), (Object)dependencyValues);
        ArrayList<IdPAttributeValue> valueList = new ArrayList<IdPAttributeValue>(dependencyValues.size());
        for (IdPAttributeValue dependencyValue : dependencyValues) {
            if (dependencyValue instanceof EmptyAttributeValue) {
                EmptyAttributeValue emptyVal = (EmptyAttributeValue)dependencyValue;
                this.log.debug("{} ignored empty value of type {}", (Object)this.getLogPrefix(), (Object)emptyVal.getDisplayValue());
                continue;
            }
            if (!(dependencyValue instanceof StringAttributeValue)) {
                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "This attribute definition only supports attribute value types of " + StringAttributeValue.class.getName() + " not values of type " + dependencyValue.getClass().getName()));
            }
            valueList.add(this.buildScopedStringAttributeValue((StringAttributeValue)dependencyValue));
        }
        resultantAttribute.setValues(valueList);
        return resultantAttribute;
    }

    @Nonnull
    private IdPAttributeValue buildScopedStringAttributeValue(@Nonnull StringAttributeValue value) throws ResolutionException {
        Constraint.isNotNull((Object)value, (String)(this.getLogPrefix() + " Attribute value can not be null"));
        String[] stringValues = value.getValue().split(this.scopeDelimiter);
        if (stringValues.length < 2) {
            this.log.error("{} Input attribute value {} does not contain delimiter {} and can not be split", new Object[]{this.getLogPrefix(), value.getValue(), this.scopeDelimiter});
            throw new ResolutionException("Input attribute value can not be split.");
        }
        this.log.debug("{} Value '{}' was split into {} at scope delimiter '{}'", new Object[]{this.getLogPrefix(), value.getValue(), stringValues, this.scopeDelimiter});
        String val0 = stringValues[0];
        String val1 = stringValues[1];
        assert (val1 != null && val0 != null);
        return ScopedStringAttributeValue.valueOf((String)val0, (String)val1);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getDataConnectorDependencies().isEmpty() && this.getAttributeDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no dependencies were configured");
        }
    }
}

