/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import net.shibboleth.idp.admin.impl.DumpConfigRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class DumpConfigRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_PARAM = "profile";
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_PARAM = "protocol";
    @Nonnull
    @NotEmpty
    public static final String SAML1_PARAM = "saml1";
    @Nonnull
    @NotEmpty
    public static final String SAML2_PARAM = "saml2";
    @Nonnull
    @NotEmpty
    public static final String CAS_PARAM = "cas";
    @Nonnull
    @NotEmpty
    public static final String OIDC_PARAM = "oidc";
    @Nonnull
    @NotEmpty
    public static final String REQUESTER_ID_PARAM = "requester";

    public DumpConfigRequestDecoder() {
        this.setProtocolMessageLoggerSubCategory("ADMIN");
    }

    protected void doDecode() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new MessageDecodingException("Unable to locate HttpServletRequest");
        }
        String profile = this.getProfileId(request);
        DumpConfigRequest message = new DumpConfigRequest(profile, this.getProtocolId(request), this.getRequesterId(request));
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)message);
        this.setMessageContext(messageContext);
        SAMLPeerEntityContext peerCtx = new SAMLPeerEntityContext();
        peerCtx.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        peerCtx.setEntityId(message.getRequesterId());
        messageContext.addSubcontext((BaseContext)peerCtx, true);
        ((SAMLProtocolContext)messageContext.ensureSubcontext(SAMLProtocolContext.class)).setProtocol(message.getProtocolId());
    }

    @Nonnull
    @NotEmpty
    protected String getProfileId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String id = StringSupport.trimOrNull((String)request.getParameter(PROFILE_PARAM));
        if (id == null) {
            throw new MessageDecodingException("Request did not contain the profile query parameter.");
        }
        if (id.startsWith("http")) {
            return id;
        }
        if (id.startsWith("/")) {
            return "http://shibboleth.net/ns/profiles" + id;
        }
        return "http://shibboleth.net/ns/profiles/" + id;
    }

    @Nonnull
    @NotEmpty
    protected String getRequesterId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String name = StringSupport.trimOrNull((String)request.getParameter(REQUESTER_ID_PARAM));
        if (name == null) {
            throw new MessageDecodingException("Request did not contain the requester query parameter.");
        }
        return name;
    }

    @Nonnull
    @NotEmpty
    protected String getProtocolId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String protocol = StringSupport.trimOrNull((String)request.getParameter(PROTOCOL_PARAM));
        if (protocol != null) {
            return protocol;
        }
        if (request.getParameter(SAML1_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:1.1:protocol";
        }
        if (request.getParameter(SAML2_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:2.0:protocol";
        }
        if (request.getParameter(CAS_PARAM) != null) {
            return "https://www.apereo.org/cas/protocol";
        }
        if (request.getParameter(OIDC_PARAM) != null) {
            return "http://openid.net/specs/openid-connect-core-1_0.html";
        }
        throw new MessageDecodingException("Request did not contain the protocol query parameter.");
    }
}

