/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;

public final class HttpServletRequestResponseContext {
    @Nonnull
    private static final ThreadLocal<HttpServletRequest> CURRENT_REQUEST = new ThreadLocal();
    @Nonnull
    private static final ThreadLocal<HttpServletResponse> CURRENT_RESPONSE = new ThreadLocal();

    private HttpServletRequestResponseContext() {
    }

    public static void loadCurrent(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Constraint.isNotNull((Object)request, (String)"HttpServletRequest may not be null");
        Constraint.isNotNull((Object)response, (String)"HttpServletResponse may not be null");
        CURRENT_REQUEST.set(request);
        CURRENT_RESPONSE.set(response);
    }

    public static void clearCurrent() {
        CURRENT_REQUEST.remove();
        CURRENT_RESPONSE.remove();
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        return CURRENT_REQUEST.get();
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return CURRENT_RESPONSE.get();
    }
}

