/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.slf4j.Logger;

public class BasicHttpServletRequestParametersValidator
extends AbstractInitializableComponent
implements HttpServletRequestValidator {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicHttpServletRequestParametersValidator.class);
    private boolean enforceAllowedParameters;
    @Nonnull
    private Set<String> allowedParameters = CollectionSupport.emptySet();
    @Nonnull
    private Set<String> requiredParameters = CollectionSupport.emptySet();
    @Nonnull
    private Set<String> uniqueParameters = CollectionSupport.emptySet();
    @Nonnull
    private Set<Set<String>> mutuallyExclusiveParameters = CollectionSupport.emptySet();

    public boolean isEnforceAllowedParameters() {
        return this.enforceAllowedParameters;
    }

    public void setEnforceAllowedParameters(boolean flag) {
        this.checkSetterPreconditions();
        this.enforceAllowedParameters = flag;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getAllowedParameters() {
        return this.allowedParameters;
    }

    public void setAllowedParameters(@Nullable Set<String> params) {
        this.checkSetterPreconditions();
        this.allowedParameters = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(params));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRequiredParameters() {
        return this.requiredParameters;
    }

    public void setRequiredParameters(@Nullable Set<String> params) {
        this.checkSetterPreconditions();
        this.requiredParameters = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(params));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getUniqueParameters() {
        return this.uniqueParameters;
    }

    public void setUniqueParameters(@Nullable Set<String> params) {
        this.checkSetterPreconditions();
        this.uniqueParameters = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(params));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<Set<String>> getMutuallyExclusiveParameters() {
        return this.mutuallyExclusiveParameters;
    }

    public void setMutuallyExclusiveParameters(@Nullable Set<Set<String>> params) {
        this.checkSetterPreconditions();
        this.mutuallyExclusiveParameters = params == null ? CollectionSupport.emptySet() : (Set)((NonnullSupplier)params.stream().map(StringSupport::normalizeStringCollection).map(CollectionSupport::copyToSet).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
    }

    @Override
    public void validate(@Nonnull HttpServletRequest request) throws ServletException {
        Constraint.isNotNull((Object)request, (String)"HttpServletRequest was null");
        Set requestParams = request.getParameterMap().keySet();
        if (this.isEnforceAllowedParameters()) {
            this.log.debug("Evaluating request for allowed parameters: {}", this.getAllowedParameters());
            for (String string : requestParams) {
                if (this.getAllowedParameters().contains(string)) continue;
                throw new ServletException("HTTP request contained a disallowed parameter: " + string);
            }
        } else {
            this.log.debug("Enforcement of allowed parameters is disabled");
        }
        this.log.debug("Evaluating request for required parameters: {}", this.getRequiredParameters());
        for (String string : this.getRequiredParameters()) {
            if (requestParams.contains(string)) continue;
            throw new ServletException("HTTP request did not contain required parameter: " + string);
        }
        this.log.debug("Evaluating request for unique parameters: {}", this.getUniqueParameters());
        for (String string : this.getUniqueParameters()) {
            String[] values = request.getParameterValues(string);
            if (values == null || values.length <= 1) continue;
            throw new ServletException("HTTP request contained multiple values for parameter: " + string);
        }
        this.log.debug("Evaluating request for mutually exclusive parameters: {}", this.getMutuallyExclusiveParameters());
        for (Set set : this.getMutuallyExclusiveParameters()) {
            if (set.size() < 2) {
                this.log.debug("Exclusivity group had < 2 members, skipping evaluation: ", (Object)set);
                continue;
            }
            Set groupIntersection = requestParams.stream().filter(p -> group.contains(p)).collect(Collectors.toSet());
            if (groupIntersection.size() <= 1) continue;
            throw new ServletException("HTTP request contained mutually exclusive parameters: " + String.valueOf(groupIntersection));
        }
    }
}

