/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.relyingparty.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.profile.relyingparty.VerifiedProfileCriterion;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.spring.security.CredentialHolder;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultRelyingPartyConfigurationResolver
extends AbstractIdentifiableInitializableComponent
implements RelyingPartyConfigurationResolver {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_RELYING_PARTY_COUNTER = "shibboleth.DefaultRelyingParty";
    @Nonnull
    @NotEmpty
    private static final String UNVERIFIED_RELYING_PARTY_COUNTER = "shibboleth.UnverifiedRelyingParty";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRelyingPartyConfigurationResolver.class);
    @Nonnull
    private List<RelyingPartyConfiguration> rpConfigurations = CollectionSupport.emptyList();
    @Nullable
    private RelyingPartyConfiguration defaultRelyingPartyConfiguration;
    @Nullable
    private RelyingPartyConfiguration unverifiedConfiguration;
    @Nonnull
    private List<Credential> signingCredentials = CollectionSupport.emptyList();
    @Nonnull
    private List<Credential> encryptionCredentials = CollectionSupport.emptyList();
    @Nullable
    private String metricName;
    @Nullable
    private Gauge<Map<String, Counter>> counterGauge;
    @Nonnull
    private Map<String, Counter> counterMap = CollectionSupport.emptyMap();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<? extends RelyingPartyConfiguration> getRelyingPartyConfigurations() {
        return this.rpConfigurations;
    }

    public void setRelyingPartyConfigurations(@Nullable Collection<? extends RelyingPartyConfiguration> configs) {
        this.checkSetterPreconditions();
        this.rpConfigurations = configs != null ? CollectionSupport.copyToList(configs) : CollectionSupport.emptyList();
    }

    @Nullable
    public RelyingPartyConfiguration getDefaultConfiguration() {
        return this.defaultRelyingPartyConfiguration;
    }

    public void setDefaultConfiguration(@Nullable RelyingPartyConfiguration configuration) {
        this.checkSetterPreconditions();
        this.defaultRelyingPartyConfiguration = configuration;
    }

    @Nullable
    public RelyingPartyConfiguration getUnverifiedConfiguration() {
        return this.unverifiedConfiguration;
    }

    public void setUnverifiedConfiguration(@Nullable RelyingPartyConfiguration configuration) {
        this.checkSetterPreconditions();
        this.unverifiedConfiguration = configuration;
    }

    @Nullable
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.metricName = StringSupport.trimOrNull((String)name);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        HashSet<String> configIds = new HashSet<String>(this.rpConfigurations.size());
        for (RelyingPartyConfiguration config : this.rpConfigurations) {
            if (configIds.contains(config.getId())) {
                throw new ComponentInitializationException("Multiple RelyingPartyConfiguration configurations with ID " + config.getId() + " detected, IDs must be unique.");
            }
            configIds.add(config.getId());
        }
        configIds.add(DEFAULT_RELYING_PARTY_COUNTER);
        configIds.add(UNVERIFIED_RELYING_PARTY_COUNTER);
        String localMetricName = this.getMetricName();
        if (localMetricName != null && !configIds.isEmpty()) {
            this.counterMap = (Map)((NonnullSupplier)configIds.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(id -> id, id -> new Counter())))).get();
            this.counterGauge = (Gauge)MetricsSupport.register((String)localMetricName, (Metric)new Gauge<Map<String, Counter>>(){

                public Map<String, Counter> getValue() {
                    return DefaultRelyingPartyConfigurationResolver.this.counterMap;
                }
            }, (boolean)true);
        }
    }

    protected void doDestroy() {
        String localMetricName = this.getMetricName();
        if (localMetricName != null && this.counterGauge != null) {
            MetricsSupport.remove((String)localMetricName, this.counterGauge);
        }
        super.doDestroy();
    }

    @Nonnull
    public Iterable<RelyingPartyConfiguration> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        this.log.debug("Resolving relying party configuration");
        if (criteria == null) {
            return CollectionSupport.emptyList();
        }
        VerifiedProfileCriterion vpc = (VerifiedProfileCriterion)criteria.get(VerifiedProfileCriterion.class);
        if (vpc == null || !vpc.isVerified()) {
            RelyingPartyConfiguration uvc = this.getUnverifiedConfiguration();
            if (uvc == null) {
                this.log.warn("Profile request was unverified, but no such configuration is available");
                return CollectionSupport.emptyList();
            }
            this.log.debug("Profile request is unverified, returning configuration {}", (Object)uvc.getId());
            this.increment(UNVERIFIED_RELYING_PARTY_COUNTER);
            return CollectionSupport.singleton((Object)uvc);
        }
        ArrayList<RelyingPartyConfiguration> matches = new ArrayList<RelyingPartyConfiguration>();
        ProfileRequestContext context = this.getProfileRequestContext(criteria);
        for (RelyingPartyConfiguration relyingPartyConfiguration : this.getRelyingPartyConfigurations()) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)relyingPartyConfiguration.getId());
            if (relyingPartyConfiguration.test((Object)context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)relyingPartyConfiguration.getId());
                this.increment(relyingPartyConfiguration.getId());
                matches.add(relyingPartyConfiguration);
                continue;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)relyingPartyConfiguration.getId());
        }
        if (matches.isEmpty()) {
            RelyingPartyConfiguration defaultConfig = this.getDefaultConfiguration();
            if (defaultConfig != null) {
                this.log.debug("No matching relying party configuration applicable, returning default: {}", (Object)defaultConfig.getId());
                this.increment(DEFAULT_RELYING_PARTY_COUNTER);
                return CollectionSupport.singleton((Object)defaultConfig);
            }
            this.log.warn("No matching relying party configuration applicable, returning nothing");
            return CollectionSupport.emptyList();
        }
        return matches;
    }

    @Nullable
    public RelyingPartyConfiguration resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        this.log.debug("Resolving relying party configuration");
        if (criteria == null) {
            return null;
        }
        VerifiedProfileCriterion vpc = (VerifiedProfileCriterion)criteria.get(VerifiedProfileCriterion.class);
        if (vpc == null || !vpc.isVerified()) {
            RelyingPartyConfiguration uvc = this.getUnverifiedConfiguration();
            if (uvc == null) {
                this.log.warn("Profile request was unverified, but no such configuration is available");
                return null;
            }
            this.log.debug("Profile request is unverified, returning configuration {}", (Object)uvc.getId());
            this.increment(UNVERIFIED_RELYING_PARTY_COUNTER);
            return uvc;
        }
        ProfileRequestContext context = this.getProfileRequestContext(criteria);
        for (RelyingPartyConfiguration relyingPartyConfiguration : this.getRelyingPartyConfigurations()) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)relyingPartyConfiguration.getId());
            if (relyingPartyConfiguration.test((Object)context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)relyingPartyConfiguration.getId());
                this.increment(relyingPartyConfiguration.getId());
                return relyingPartyConfiguration;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)relyingPartyConfiguration.getId());
        }
        RelyingPartyConfiguration defaultConfig = this.getDefaultConfiguration();
        if (defaultConfig != null) {
            this.log.debug("No matching relying party configuration applicable, returning default: {}", (Object)defaultConfig.getId());
            this.increment(DEFAULT_RELYING_PARTY_COUNTER);
            return defaultConfig;
        }
        this.log.warn("No matching relying party configuration applicable, returning nothing");
        return null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<Credential> getSigningCredentials() {
        return this.signingCredentials;
    }

    @Autowired
    @Qualifier(value="signing")
    public void setSigningCredentials(@Nullable List<CredentialHolder> credentials) {
        this.checkSetterPreconditions();
        this.signingCredentials = credentials != null ? (List)((NonnullSupplier)credentials.stream().flatMap(h -> h.getCredentials().stream()).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get() : CollectionSupport.emptyList();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<Credential> getEncryptionCredentials() {
        return this.encryptionCredentials;
    }

    @Autowired
    @Qualifier(value="encryption")
    public void setEncryptionCredentials(@Nullable List<CredentialHolder> credentials) {
        this.checkSetterPreconditions();
        this.encryptionCredentials = credentials != null ? (List)((NonnullSupplier)credentials.stream().flatMap(h -> h.getCredentials().stream()).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get() : CollectionSupport.emptyList();
    }

    private void increment(@Nullable String name) {
        Counter counter = this.counterMap.get(name);
        if (counter != null) {
            counter.inc();
        }
    }

    @Nullable
    private ProfileRequestContext getProfileRequestContext(@Nonnull CriteriaSet criteria) {
        ProfileRequestContextCriterion prcCriterion = (ProfileRequestContextCriterion)criteria.get(ProfileRequestContextCriterion.class);
        if (prcCriterion != null) {
            return prcCriterion.getProfileRequestContext();
        }
        String entityID = this.resolveEntityID(criteria);
        this.log.debug("Resolved effective entityID from criteria: {}", (Object)entityID);
        EntityDescriptor entityDescriptor = this.resolveEntityDescriptor(criteria);
        this.log.debug("Resolved effective entity descriptor from criteria: {}", (Object)entityDescriptor);
        RoleDescriptor roleDescriptor = this.resolveRoleDescriptor(criteria);
        this.log.debug("Resolved effective role descriptor from criteria: {}", (Object)roleDescriptor);
        if (entityID != null || entityDescriptor != null || roleDescriptor != null) {
            ProfileRequestContext prc = new ProfileRequestContext();
            RelyingPartyContext rpc = (RelyingPartyContext)prc.ensureSubcontext(RelyingPartyContext.class);
            rpc.setVerified(Boolean.valueOf(true));
            rpc.setRelyingPartyId(entityID);
            if (entityDescriptor != null || roleDescriptor != null) {
                SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)prc.ensureSubcontext(SAMLPeerEntityContext.class);
                rpc.setRelyingPartyIdContextTree((BaseContext)peerContext);
                peerContext.setEntityId(entityID);
                if (roleDescriptor != null) {
                    peerContext.setRole(roleDescriptor.getSchemaType() != null ? roleDescriptor.getSchemaType() : roleDescriptor.getElementQName());
                }
                SAMLMetadataContext metadataContext = (SAMLMetadataContext)peerContext.ensureSubcontext(SAMLMetadataContext.class);
                metadataContext.setEntityDescriptor(entityDescriptor);
                metadataContext.setRoleDescriptor(roleDescriptor);
            }
            return prc;
        }
        return null;
    }

    @Nullable
    private String resolveEntityID(@Nonnull CriteriaSet criteria) {
        EntityIdCriterion eic = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (eic != null) {
            return eic.getEntityId();
        }
        EntityDescriptor ed = this.resolveEntityDescriptor(criteria);
        if (ed != null) {
            return ed.getEntityID();
        }
        return null;
    }

    @Nullable
    private EntityDescriptor resolveEntityDescriptor(@Nonnull CriteriaSet criteria) {
        RoleDescriptor rd = this.resolveRoleDescriptor(criteria);
        if (rd != null && rd.getParent() != null && rd.getParent() instanceof EntityDescriptor) {
            return (EntityDescriptor)rd.getParent();
        }
        return null;
    }

    @Nullable
    private RoleDescriptor resolveRoleDescriptor(@Nonnull CriteriaSet criteria) {
        RoleDescriptorCriterion rdc = (RoleDescriptorCriterion)criteria.get(RoleDescriptorCriterion.class);
        if (rdc != null) {
            return rdc.getRole();
        }
        return null;
    }
}

