/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;

public final class IdPAttributeSupport {
    private IdPAttributeSupport() {
    }

    @Nonnull
    @Live
    public static Map<String, IdPAttribute> toMapNoDuplicates(@Nullable Collection<IdPAttribute> attributes) {
        HashMap<String, IdPAttribute> accumulator = new HashMap<String, IdPAttribute>();
        if (attributes == null) {
            return accumulator;
        }
        accumulator.putAll((Map)((NonnullSupplier)attributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteContext", (boolean)true))))).get());
        return accumulator;
    }

    @Nonnull
    @Live
    public static Map<String, IdPAttribute> toMapMergeDuplicates(@Nullable Collection<IdPAttribute> attributes) {
        HashMap<String, IdPAttribute> accumulator = new HashMap<String, IdPAttribute>();
        return IdPAttributeSupport.withMapMergeDuplicates(accumulator, attributes);
    }

    @Nonnull
    @Live
    public static Map<String, IdPAttribute> withMapMergeDuplicates(@Nonnull @Live Map<String, IdPAttribute> existingAttributes, @Nonnull Map<String, IdPAttribute> newAttributes) {
        return IdPAttributeSupport.withMapMergeDuplicates(existingAttributes, newAttributes.values());
    }

    @Nonnull
    @Live
    public static Map<String, IdPAttribute> withMapMergeDuplicates(@Nonnull @Live Map<String, IdPAttribute> existingAttributes, @Nullable Collection<IdPAttribute> newAttributes) {
        if (newAttributes == null) {
            return existingAttributes;
        }
        for (IdPAttribute attribute : newAttributes) {
            IdPAttribute newAttribute;
            IdPAttribute oldAttr = existingAttributes.get(attribute.getId());
            if (oldAttr == null) {
                existingAttributes.put(attribute.getId(), attribute);
                continue;
            }
            try {
                newAttribute = oldAttr.clone();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>(newAttribute.getValues());
            values.addAll(attribute.getValues());
            newAttribute.setValues(values);
            existingAttributes.remove(attribute.getId());
            existingAttributes.put(newAttribute.getId(), newAttribute);
        }
        return existingAttributes;
    }
}

