/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class DateTimeAttributeValue
implements IdPAttributeValue {
    @Nonnull
    private final Instant value;

    public DateTimeAttributeValue(@Nonnull @ParameterName(name="attributeValue") Instant attributeValue) {
        this.value = (Instant)Constraint.isNotNull((Object)attributeValue, (String)"Attribute value cannot be null or empty");
    }

    public DateTimeAttributeValue(@Nonnull @ParameterName(name="attributeValue") ZonedDateTime attributeValue) {
        Instant val = ((ZonedDateTime)Constraint.isNotNull((Object)attributeValue, (String)"Attribute value cannot be null or empty")).toInstant();
        assert (val != null);
        this.value = val;
    }

    @Override
    @Nonnull
    public Object getNativeValue() {
        return this.value;
    }

    @Nonnull
    public final Instant getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getDisplayValue() {
        String result = this.value.toString();
        assert (result != null);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateTimeAttributeValue)) {
            return false;
        }
        DateTimeAttributeValue other = (DateTimeAttributeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

